# **myApps4.2authtime接口说明文档 V1.0**

## 1.  RESTful API 设计规范与约定说明

### 1.1  **路径规则（Endpoint rule）**

路径又称"终点"（endpoint），表示API的具体网址。

在RESTful架构中，每个网址代表一种资源（resource），所以网址中不能有动词，只能有名词，而且所用的名词往往与数据库的表格名对应。一般来说，数据库中的表都是同种记录的"集合"（collection），所以API中的名词也应该使用复数。

举例来说，有一组API分别提供Document、表单、视图的信息，则它的路径应该设计成下面这样。

```
-   https://api.example.com/runtime/documents

-   https://api.example.com/runtime/forms

-   https://api.example.com/runtime/views
```

以上路径规则是面向资源的，对于CRUD操作是非常友好的，但是面向一些“动作”或“行为”等一些不符合CRUD的服务请求（如操作按钮的运行执行前脚本），单纯的面向资源的路径构建规则就会让人困惑了。

这种情况我们可以以“子资源”来对待（资源后面加行为动词），例如:GitHub上，对一个gists加星操作：

```
PUT /gists/:id/star
```

并且取消星操作：

```
DELETE /gists/:id/star
```

举例来说，有一组API分别提供执行操作按钮的执行前、执行后脚本和业务处理行为，则它的路径应该设计成下面这样。

```
-   https://api.example.com/runtime/activitys/{id}/excute

-   https://api.example.com/runtime/activitys/{id}/beforactionscript

-   https://api.example.com/runtime/activitys/{id}/afteractionscript
```

### 1.2  **HTTP动词 (Http method)**

对于资源的具体操作类型，由HTTP动词表示。

常用的HTTP动词有下面五个（括号里是对应的SQL命令）。

```
-   GET（SELECT）：从服务器取出资源（一项或多项）。

-   POST（CREATE）：在服务器新建一个资源。

-   PUT（UPDATE）：在服务器更新资源（客户端提供改变后的完整资源）。

-   PATCH（UPDATE）：在服务器更新资源（客户端提供改变的属性）。

-   DELETE（DELETE）：从服务器删除资源。
```

下面是一些例子。

```
-   GET /runtime/documents：获取Document集合

-   POST /runtime/documents：新建一个Document

-   GET /runtime/documents/{id}：获取由ID指定的Document

-   PUT /runtime/documents/{id}：更新由ID指定的Document（客户端提供全部信息，完整更新）

-   PATCH /runtime/documents/{id}：更新由ID指定的Document（客户端提供部分信息，局部更新）

-   DELETE /runtime/documents/{id}：删除由ID指定的Document
```

### 1.3  **过滤信息（Filtering）**

如果记录数量很多，服务器不可能都将它们返回给用户。API应该提供参数，过滤返回结果。

下面是一些常见的参数。

```
-   ?_page=2&_page_lines=30：指定第几页，以及每页的记录数。

-   ?_sortby=name&_order=asc：指定返回结果按照哪个属性排序，以及排序顺序。

-   ?form_type =1：指定筛选条件。
```

参数的设计允许存在冗余，即允许API路径和URL参数偶尔有重复。比如，

```
GET /runtime/documents/{id}/flowhis
```

 与 

```
GET /runtime/flowhis?doc_id={id}
```

的含义是相同的。

### 1.4 **状态码（Status codes）**

------

服务器向用户返回的状态码和提示信息，常见的有以下一些（方括号中是该状态码对应的HTTP动词）。

下面是一些常见的状态码。

```
-   200 OK - [GET]：服务器成功返回用户请求的数据，该操作是幂等的（Idempotent）。

-   201 CREATED - [POST/PUT/PATCH]：用户新建或修改数据成功。

-   202 Accepted - [\*]：表示一个请求已经进入后台排队（异步任务）

-   204 NO CONTENT - [DELETE]：用户删除数据成功。

-   400 INVALID REQUEST -
    [POST/PUT/PATCH]：用户发出的请求有错误，服务器没有进行新建或修改数据的操作，该操作是幂等的。

-   401 Unauthorized - [\*]：表示用户没有权限（令牌、用户名、密码错误）。

-   403 Forbidden - [\*] 表示用户得到授权（与401错误相对），但是访问是被禁止的。

-   404 NOT FOUND -
    [\*]：用户发出的请求针对的是不存在的记录，服务器没有进行操作，该操作是幂等的。

-   406 Not Acceptable -
    [GET]：用户请求的格式不可得（比如用户请求JSON格式，但是只有XML格式）。

-   410 Gone -[GET]：用户请求的资源被永久删除，且不会再得到的。

-   422 Unprocesable entity - [POST/PUT/PATCH]
    当创建一个对象时，发生一个验证错误。

-   500 INTERNAL SERVER ERROR -
    [\*]：服务器发生错误，用户将无法判断发出的请求是否成功。
    
-  4001 INTERNAL SERVER ERROR -
    [\*]：服务器校验错误
```

### 1.5  **错误处理（Error handling）**

就像html错误页面能够显示错误信息一样，API
也应该能返回可读的错误信息，它应该和一般的资源格式一致。

- API应该始终返回相应的状态码，以反映服务器或者请求的状态。
- API的错误码可以分为两部分，400系列和500系列，400系列表明客户端错误：如错误的请求格式等。500系列表示服务器错误。
- API应该至少将所有的400系列的错误以JSON形式返回。如果可能500系列的错误也应该如此。
- JSON格式的错误应该包含以下信息：一个有用的错误信息，一个唯一的错误码，以及任何可能的详细错误描述。如下：

```
{
  "errcode" : 40035,
  "errmsg" : "不合法的参数"
}

```

- 对PUT,POST,PATCH的输入的校验也应该返回相应的详细错误信息，例如：

```
{  
          "errcode" : 40035,  
          "errmsg" : "Validation Failed",  
          "errors" : [
            {  
              "errcode" : 1234,  
              "field" : "first_name",  
              "errmsg" : "First name cannot have fancy characters"  
            },  
            {  
               "errcode" : 1234,  
               "field" : "password",  
               "errmsg" : "Password cannot be blank"  
            }  
          ]  
        }

```

### 1.6 **数据结构（Data structure）**

- 在POST,PUT,PATCH上使用JSON作为输入。
- 注意使用JSON传输的时候，要求请求头里面加入：Content-Type：applicatin/json.否则抛出415异常（unsupported
  media type）。
- 服务器返回的数据格式，统一使用JSON作为输出。

> 服务器返回的JSON数据结构统一如下：

```
{
  "errcode" : 0,
  "errmsg" : "some message",
  "data" : {},
  "errors" : []
}

```

> 参数说明：

| 参数    | 必须 | 说明                 |
| ------- | ---- | -------------------- |
| errcode | 是   | 状态码/返回码        |
| errmsg  | 是   | 消息                 |
| data    | 是   | 服务端返回的数据对象 |
| errors  | 否   | 详细错误信息         |

### 1.7 **其他**

------

1. 客户端控制服务端是否需要返回数据、且返回哪些数据的约定
2. Urls命名规则统一使用蛇形命名法（下划线和小写）



## 登录和注销

### 登录

**请求方式：** POST
**请求地址：** /api/authtime/login

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
|          |          |          |

**请求包体**：

```
{
    "username": "admin",
    "password": "VlbWxpbms=dG",
    "checkcode":"y5wc"
}
```

**权限说明：**



**权限说明：**

无。

**返回结果：**

```
{
    "msg": "账号或密码错误!",
    "checkcodeImg": "",
    "code": "1"
}

```

**参数说明：**

| **参数**           | **说明**                     |
| ------------------ | ---------------------------- |
| code            | 返回码（0=成功，1=失败）     |
| msg             | 提示消息       |
| checkcodeImg               | 验证码（base64）                   |

### 注销

请求方式：** GET  
**请求地址：** /api/authtime/logout

**参数说明：**

无



## 2.  **企业域**

### 2.1获取企业域列表

**请求方式：** POST  
**请求地址：** /api/authtime/domains?currpage={currpage}&
pagelines={pagelines}

**参数说明：**

| **参数** | **必须** | **说明**   |                    |
| -------- | -------- | ---------- | ------------------ |
| currpage | 是       | 当前页码   |                    |
| lines    | 是       | 页面大小   |                    |
| name     | 否       | 企业域名称 |                    |
| username | 否       | 管理员名称 | 为啥要管理员名称？ |

**请求包体：**

{
  	"name": "企业域名称",

        "username": "管理员名称" 

}

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"licenseType": "S.标准版",
		"linesPerPage": 10,
		"pageCount": 1,
		"pageNo": 1,
		"rowCount": 2,
		"datas": [{
			"name": "测试",
			"id": "3CffNlgt9B9StIjIUPB",
			"status": 1,
			"logoUrl": "../uploads/lib/icon/p87_RMB.png",
			"systemName": "1111",
			"users": [{
				"userid": "0JyBHSIZPmSOQpQwd1K",
				"username": "宣传j"
			}, {
				"userid": "iM16sApAfO0CdXXFnOH",
				"username": "RU"
			}, {
				"userid": "0TblO2uKjQ2sLDY64yF",
				"username": "junye"
			}, {
				"userid": "zPsp2hk7CEwtqeMCwtj",
				"username": "管理员"
			}, {
				"userid": "2TE7lzsbdyqLhndabbN",
				"username": "sam_hr"
			}]
		}, {
			"name": "2",
			"id": "__t64lurS4a2ZuWARnvcU",
			"status": 1,
			"logoUrl": "",
			"systemName": "",
			"users": []
		}]
	}
}
```

**参数说明：**

| **参数**                  | **说明**                       |      |
| ------------------------- | ------------------------------ | ---- |
| errcode                   | 返回码（0=成功，1=失败）       |      |
| errmsg                    | 对返回码的文本描述内容         |      |
| data                      | 企业域集合                     |      |
| data[0].id                | 企业域id                       |      |
| data[0].name              | 企业域名称                     |      |
| data[0].states            | 企业域状态（1=激活，0=未激活） |      |
| data[0].users             | 企业域管理员                   |      |
| data[0].users[0].userid   | 企业域管理员id                 |      |
| data[0].users[0].username | 企业域管理员名称               |      |

### 2.2获取企业域基本信息

**请求方式：** GET  
**请求地址：** /api/authtime/domain/{id}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| id       | 是       | 企业域id |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "name": "测试",
        "id": "3CffNlgt9B9StIjIUPB",
        "systemName": "",
        "smsMemberCode": "sam_hr",
        "smsMemberPwd": "123456",
        "description": "测试",
        "skinType": "H5",
        "logourl": "",
        "status": 1,
        "users": [
            {
                "userid": "2TE7lzsbdyqLhndabbN",
                "username": "sam_hr"
            },
            {
                "userid": "zPsp2hk7CEwtqeMCwtj",
                "username": "管理员"
            }
        ]
    }
}
```

**参数说明：**

| **参数**           | **说明**                 |
| ------------------ | ------------------------ |
| errcode            | 返回码（0=成功，1=失败） |
| errmsg             | 对返回码的文本描述内容   |
| data               | 企业域集合               |
| data.id            | 企业域id                 |
| data.name          | 企业域名称               |
| data.systemName    | 系统名称                 |
| data.smsMemberCode | 天翎短信平台账号         |
| data.smsMemberPwd  | 天翎短信平台密码         |
| data.description   | 描述                     |
| data.skinType      | 默认皮肤                 |
| data.logourl       | logo地址                 |
| data.status        | 激活状态                 |
| data.users[0].id   | 管理员id                 |
| data.users[0].name | 管理员名称               |

### 2.3测试企业域短信发送

**请求方式：** GET  
**请求地址：** /api/authtime/domain/{domainid}/sms/{telephone}

**参数说明：**

| **参数**  | **必须** | **说明**     |
| --------- | -------- | ------------ |
| telephone | 是       | 测试手机号码 |
| domainid  | 是       | 企业域id     |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "type": "success",
        "message": "success"
    }
}

```

**参数说明：**

| **参数**        | **说明**                 |
| --------------- | ------------------------ |
| errcode         | 返回码（0=成功，1=失败） |
| errmsg          | 对返回码的文本描述内容   |
| data            | 企业域集合               |
| data[0].type    | 提示类型                 |
| data[0].success | 提示消息                 |

### 2.4获取企业域logo集合

**请求方式：** GET  
**请求地址：** /api/authtime/icons

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| 无       | 否       |          |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "name": "16x16_0020",
            "size": null,
            "length": null,
            "width": 0,
            "path": "E:/WorkSpace/obpm4.3/obpm-demo/uploads/lib/icon/16x16_0020",
            "fileType": 2
        }
        {
            "name": "teemlink-logo.png",
            "size": "60 x 61",
            "length": "4.88 KB",
            "width": 60,
            "path": "E:/WorkSpace/obpm4.3/obpm-demo/uploads/lib/icon/teemlink-logo.png",
            "fileType": 1
        },
        {
            "name": "_H5_small_icon",
            "size": null,
            "length": null,
            "width": 0,
            "path": "E:/WorkSpace/obpm4.3/obpm-demo/uploads/lib/icon/_H5_small_icon",
            "fileType": 2
        }
    ]
}

```

**参数说明：**

| **参数**         | **说明**                 |
| ---------------- | ------------------------ |
| errcode          | 返回码（0=成功，1=失败） |
| errmsg           | 对返回码的文本描述内容   |
| data             | 企业域集合               |
| data[0].name     | logo名称                 |
| data[0].size     | logo尺寸                 |
| data[0].length   | 文件大小                 |
| data[0].width    | logo长                   |
| data[0].path     | logo绝对路径             |
| data[0].fileType | 文件类型                 |

### 2.5新建企业域基本信息

**请求方式：** POST
**请求地址：** /api/authtime/domain/

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
|          |          |          |

**请求包体**：

```
{
    "name": "企业域名称",

    "systemName": "系统名称",

    "smsMemberCode": "短袖天翎平台账号",

    "smsMemberPwd": "短袖天翎平台密码",

    "description": "描述",

    "status":1（状态） 

    "skinType":"企业域默认皮肤" 

    "logoUrl":"logo的具体地址" 

}
```

**权限说明：**



**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "__cj05csjUFPNjw5TWCS5",
        "name": "ekkotest",
        "systemName": "ekkotest",
        "smsMemberCode": "sam_hr",
        "smsMemberPwd": "123456",
        "description": "描述test",
        "skinType": "H5",
        "logoUrl": "",
        "status": 1,
        "users": []
    }
}

```

**参数说明：**

| **参数**           | **说明**                     |
| ------------------ | ---------------------------- |
| errcode            | 返回码（0=成功，1=失败）     |
| errmsg             | 对返回码的文本描述内容       |
| data               | 企业域集合                   |
| data.id            | 企业域id                     |
| data.name          | 企业域名称                   |
| data.systemName    | 企业域系统名称               |
| data.smsMemberCode | 天翎短袖平台账号             |
| data.smsMemberPwd  | 天翎短袖平台密码             |
| data.description   | 描述                         |
| data.skinType      | 默认皮肤                     |
| data.logoUrl       | logo绝对路径                 |
| data.status        | 激活状态（1=激活，0=未激活） |
| data.users[0].id   | 企业域管理员id               |
| data.user[0].name  | 企业域管理员名称             |

### 2.6修改企业域基本信息

**请求方式：** PUT
**请求地址：** /api/authtime/domain/{id}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| id       | 是       | 企业域id |

**请求包体**：

```
{
    "id": "企业域id",

   "name": "企业域名称",

    "systemName": "系统名称",

    "smsMemberCode": "天翎短袖平台账号",

    "smsMemberPwd": "天翎短信平台密码",

    "description": "描述",

    "status":激活状态（int），（1=激活，0=未激活） 

    "skinType":"默认皮肤" 

    "logoUrl":"logo路径" 

}
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "__cj05csjUFPNjw5TWCS5",
        "name": "ekkotest",
        "systemName": "ekkotest",
        "smsMemberCode": "sam_hr",
        "smsMemberPwd": "123456",
        "description": "描述test11",
        "skinType": "H5",
        "logoUrl": "",
        "status": 1,
        "users": []
    }
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 企业域集合               |
| data[0].id   | 企业域id                 |
| data[0].name | 企业域名称               |

### 2.7企业域用户导出

**请求方式：** GET  
**请求地址：** /api/authtime/domain/{domainid}/user/export

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid | 是       | 企业域id |

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": "导出成功"
}
```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 企业域集合               |
| data[0].id   | 企业域id                 |
| data[0].name | 企业域名称               |

### 2.8企业域用户导入

**请求方式：** POST  
**请求地址：** /api/authtime/domain/{domainid}/user/import

**参数说明：**

| **参数** | **必须** | **说明**                                     |
| -------- | -------- | -------------------------------------------- |
| domainid | 是       | 企业域id                                     |
| path     | 是       | 上传文件的相对路径（14.1上传之后返回的路径） |

请求包体**：

```
{
    "path": "/uploads/lib/icon/upload/用户列表.xls"
}
```



**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "general": {
            "USER_ADD_FAIL": 0,
            "DEPT_ADD_SUCCESS": 1,
            "DEPT_ADD_FAIL": 0,
            "USER_ADD_SUCCESS": 2
        },
        "detail": []
    }
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 企业域集合               |
| data[0].id   | 企业域id                 |
| data[0].name | 企业域名称               |



### 2.9删除企业域

**请求方式：** DELETE  
**请求地址：** /api/authtime/domain

**参数说明：**

**请求包体**：

```
 [
    "ID1",
    "ID2",
    "ID3"
]

```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "删除成功"
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 提示信息                 |

### 2.10删除自定义图标

**请求方式：** DELETE  
**请求地址：** /api/authtime/icon

**参数说明：**

| **参数** | **必须** | **说明**             |
| -------- | -------- | -------------------- |
| path     | 是       | 自定义icon的相对路径 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "删除成功"
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 提示信息                 |

### 2.11获取皮肤列表

**请求方式：** GET  
**请求地址：** /api/authtime/skins

**参数说明：**

无。

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "success",
	"data": {
		"vue": "vue",
		"good": "good"
	}
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 提示信息                 |

### 2.12企业域同步LDAP部门及用户信息

**请求方式：** POST  
**请求地址：** /api/authtime/domain/synchldap?domainid={domainid}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid | 是       | 企业域id |

**权限说明：**

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "success",
	"data": "同步成功"
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 提示信息                 |

### 2.13重设Secret Key

**请求方式：** PUT
**请求地址：** /api/authtime/domain/{id}/secret

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| id       | 是       | 企业域id |

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |

## 3.  **部门**

### 3.1获取根部门

**请求方式：** GET  
**请求地址：/api/authtime/domain/{domainid}/department/root

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid | 是       | 企业域id |



### 3.1获取子部门

**请求方式：** GET  
**请求地址：**/api/authtime/domain/{domainid}/department/{departmentid}/subdepartments

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| departmentid | 是   |     部门id     |
| domainid | 是 | 企业域id |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        //返回departmentvo对象结构...
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 部门节点集合             |



### 3.2获取部门详情

**请求方式：** GET  
**请求地址：** /api/authtime/department/{id}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| id | 是   |     部门id     |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "id": "Z42xU8LmniRouZ93E7s",
        "name": "测试",
        "superior": null,
        "code": "1",
        "level": 0,
        "indexCode": "5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s",
        "domain": {
            "id": "3CffNlgt9B9StIjIUPB",
            "sendHost": "191.91.919.1",
            "sendAddress": "123@1.com",
            "sendAccount": "admin",
            "sendPassword": "123456",
            "ccAddress": "234@1.com",
            "isUseClient": "true",
            "functionDomain": "",
            "trash": null,
            "sender": "",
            "draft": "",
            "removed": "",
            "fetchServer": "",
            "fetchServerPort": "",
            "fetchProtocol": "",
            "fetchssl": "true",
            "smtpServer": null,
            "smtpServerPort": "",
            "smtpAuthenticated": "",
            "smtpssl": "true",
            "name": "测试"
        },
        "valid": 1,
        "orderByNo": 0,
        "weixinDeptId": "1",
        "lanxinDeptId": "",
        "field1": null,
        "field2": null,
        "field3": null,
        "field4": null,
        "field5": null,
        "field6": null,
        "field7": null,
        "field8": null,
        "field9": null,
        "field10": null,
        "fieldExtendsValues": []
    }
}

```

**参数说明：**

| **参数**                  | **说明**                 |
| ------------------------- | ------------------------ |
| errcode                   | 返回码（0=成功，1=失败） |
| errmsg                    | 对返回码的文本描述内容   |
| data                      | 部门详情                 |
| data.id                   | 部门id                   |
| data.name                 | 部门名称                 |
| data.superior             | 部门上级                 |
| data.code                 | 代码                     |
| data.level                | 等级                     |
| data.domain               | 企业域信息               |
| data.valid                | 是否有效                 |
| data.orderByNo            | 排序号                   |
| data.weixinDeptId         | 微信部门id               |
| data.lanxinDeptId         | 蓝信部门id               |
| data.field[i]             | 扩展字段【i】            |
| data.fieldExtendsValues[] | 要显示的扩展字段集合     |
| indexCode                 | 索引代码                 |

### 3.3新建部门信息

**请求方式：** POST
**请求地址：** /api/authtime/domain/{domainid}/department

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid | 是       | 企业域id |

**请求包体**：

```
{

    "sortId": "",

    "indexCode": "",

    "weixinDeptId": "",

    "lanxinDeptId": "",

    "name": "测试微信1",

    "code": "0",

    "orderByNo": 1,

     "valid": 1,
     
     "field1": "部门新建字段",
     
     "superiorid": "Z42xU8LmniRouZ93E7s"
}
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "保存成功",
    "data": {
        "id": "__Mm633IeSs6dVedFqglk",
        "name": "测试微信1",
        "superior": {
            "id": "Z42xU8LmniRouZ93E7s",
            "name": "测试",
            "superior": null,
            "code": "1",
            "level": 0,
            "indexCode": "5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s",
            "domain": {
                "id": "3CffNlgt9B9StIjIUPB",
                "sendHost": "191.91.919.1",
                "sendAddress": "123@1.com",
                "sendAccount": "admin",
                "sendPassword": "123456",
                "ccAddress": "234@1.com",
                "isUseClient": "true",
                "functionDomain": "",
                "trash": null,
                "sender": "",
                "draft": "",
                "removed": "",
                "fetchServer": "",
                "fetchServerPort": "",
                "fetchProtocol": "",
                "fetchssl": "true",
                "smtpServer": null,
                "smtpServerPort": "",
                "smtpAuthenticated": "",
                "smtpssl": "true",
                "name": "测试"
            },
            "valid": 1,
            "orderByNo": 0,
            "weixinDeptId": "1",
            "lanxinDeptId": "",
            "field1": null,
            "field2": null,
            "field3": null,
            "field4": null,
            "field5": null,
            "field6": null,
            "field7": null,
            "field8": null,
            "field9": null,
            "field10": null,
            "fieldExtendsValues": []
        },
        "code": "0",
        "level": 0,
        "indexCode": "5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s___Mm633IeSs6dVedFqglk",
        "domain": {
            "id": "3CffNlgt9B9StIjIUPB",
            "sendHost": "191.91.919.1",
            "sendAddress": "123@1.com",
            "sendAccount": "admin",
            "sendPassword": "123456",
            "ccAddress": "234@1.com",
            "isUseClient": "true",
            "functionDomain": "",
            "trash": null,
            "sender": "",
            "draft": "",
            "removed": "",
            "fetchServer": "",
            "fetchServerPort": "",
            "fetchProtocol": "",
            "fetchssl": "true",
            "smtpServer": null,
            "smtpServerPort": "",
            "smtpAuthenticated": "",
            "smtpssl": "true",
            "name": "测试"
        },
        "valid": 1,
        "orderByNo": 1,
        "weixinDeptId": null,
        "lanxinDeptId": null,
        "field1": "部门新建字段",
        "field2": null,
        "field3": null,
        "field4": null,
        "field5": null,
        "field6": null,
        "field7": null,
        "field8": null,
        "field9": null,
        "field10": null,
        "fieldExtendsValues": []
    }
}
```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 企业域集合               |
| data[0].id   | 企业域id                 |
| data[0].name | 企业域名称               |

### 3.4更新部门信息

**请求方式：** PUT
**请求地址：**/api/authtime/domain/{domainid}/department/{id}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| id       | 是       | 部门id   |
| domainid | 是       | 企业域id |
|          |          |          |

**请求包体**：

```
{

    "id": "__YDoiFDn8a3nGWWoH4xu",

    "sortId": "156930872825700000",

    "indexCode": "5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s_3nvysoo7nWKoxp0FShm___YDoiFDn8a3nGWWoH4xu",

    "weixinDeptId": "44",

    "lanxinDeptId": "",

    "name": "测试微信",

    "code": "代码",

    "orderByNo": "1",

     "valid": "1",
     
     "field1": "部门新建字段",
     
     "superiorid": "Z42xU8LmniRouZ93E7s"
}
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "保存成功",
    "data": {
        "id": "__Mm633IeSs6dVedFqglk",
        "name": "测试微信1",
        "superior": {
            "id": "Z42xU8LmniRouZ93E7s",
            "name": "测试",
            "superior": null,
            "code": "1",
            "level": 0,
            "indexCode": "5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s",
            "domain": {
                "id": "3CffNlgt9B9StIjIUPB",
                "sendHost": "191.91.919.1",
                "sendAddress": "123@1.com",
                "sendAccount": "admin",
                "sendPassword": "123456",
                "ccAddress": "234@1.com",
                "isUseClient": "true",
                "functionDomain": "",
                "trash": null,
                "sender": "",
                "draft": "",
                "removed": "",
                "fetchServer": "",
                "fetchServerPort": "",
                "fetchProtocol": "",
                "fetchssl": "true",
                "smtpServer": null,
                "smtpServerPort": "",
                "smtpAuthenticated": "",
                "smtpssl": "true",
                "name": "测试"
            },
            "valid": 1,
            "orderByNo": 0,
            "weixinDeptId": "1",
            "lanxinDeptId": "",
            "field1": null,
            "field2": null,
            "field3": null,
            "field4": null,
            "field5": null,
            "field6": null,
            "field7": null,
            "field8": null,
            "field9": null,
            "field10": null,
            "fieldExtendsValues": []
        },
        "code": "0",
        "level": 0,
        "indexCode": "5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s___Mm633IeSs6dVedFqglk",
        "domain": {
            "id": "3CffNlgt9B9StIjIUPB",
            "sendHost": "191.91.919.1",
            "sendAddress": "123@1.com",
            "sendAccount": "admin",
            "sendPassword": "123456",
            "ccAddress": "234@1.com",
            "isUseClient": "true",
            "functionDomain": "",
            "trash": null,
            "sender": "",
            "draft": "",
            "removed": "",
            "fetchServer": "",
            "fetchServerPort": "",
            "fetchProtocol": "",
            "fetchssl": "true",
            "smtpServer": null,
            "smtpServerPort": "",
            "smtpAuthenticated": "",
            "smtpssl": "true",
            "name": "测试"
        },
        "valid": 1,
        "orderByNo": 1,
        "weixinDeptId": null,
        "lanxinDeptId": null,
        "field1": "部门新建字段",
        "field2": null,
        "field3": null,
        "field4": null,
        "field5": null,
        "field6": null,
        "field7": null,
        "field8": null,
        "field9": null,
        "field10": null,
        "fieldExtendsValues": []
    }
}
```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 企业域集合               |
| data[0].id   | 企业域id                 |
| data[0].name | 企业域名称               |

### 3.5查询对应部门列表

**请求方式：** POST  
**请求地址：** /api/authtime/domain/{domainid}/departments?

currpage={currpage}&pagelines={pagelines}&superiorid={superiorid}&

orderby ={orderby}



**参数说明：**

| **参数**   | **必须** | **说明** |
| ---------- | -------- | -------- |
| name       | 否       | 部门名称 |
| currpage   | 否       | 当前页码 |
| pagelines  | 否       | 页面尺寸 |
| superiorid | 否       | 上级id   |
| orderby    | 否       | 排序字段 |
|            |          |          |

**请求包体：**

{
  	"name": "部门名称"

}

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 29,
        "linesPerPage": 10,
        "pageNo": 1,
        "datas": [
            {
                "id": "1xazSG6T8KhaYufkfV7",
                "name": "测试1",
                "superior": {
                    "id": "febFF7bdzJJ0HJyh3dc",
                    "name": "测试",
                    "superior": {
                        "id": "Z42xU8LmniRouZ93E7s",
                        "name": "测试",
                        "superior": null,
                        "code": "1",
                        "level": 0,
                        "indexCode": "5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s",
                        "domain": {
                            "id": "3CffNlgt9B9StIjIUPB",
                            "sendHost": "191.91.919.1",
                            "sendAddress": "123@1.com",
                            "sendAccount": "admin",
                            "sendPassword": "123456",
                            "ccAddress": "234@1.com",
                            "isUseClient": "true",
                            "functionDomain": "",
                            "trash": null,
                            "sender": "",
                            "draft": "",
                            "removed": "",
                            "fetchServer": "",
                            "fetchServerPort": "",
                            "fetchProtocol": "",
                            "fetchssl": "true",
                            "smtpServer": null,
                            "smtpServerPort": "",
                            "smtpAuthenticated": "",
                            "smtpssl": "true",
                            "name": "测试"
                        },
                        "valid": 1,
                        "orderByNo": 0,
                        "weixinDeptId": "1",
                        "lanxinDeptId": "",
                        "field1": null,
                        "field2": null,
                        "field3": null,
                        "field4": null,
                        "field5": null,
                        "field6": null,
                        "field7": null,
                        "field8": null,
                        "field9": null,
                        "field10": null,
                        "fieldExtendsValues": []
                    },
                    "code": null,
                    "level": 1,
                    "indexCode": "5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s_febFF7bdzJJ0HJyh3dc",
                    "domain": {
                        "id": "3CffNlgt9B9StIjIUPB",
                        "sendHost": "191.91.919.1",
                        "sendAddress": "123@1.com",
                        "sendAccount": "admin",
                        "sendPassword": "123456",
                        "ccAddress": "234@1.com",
                        "isUseClient": "true",
                        "functionDomain": "",
                        "trash": null,
                        "sender": "",
                        "draft": "",
                        "removed": "",
                        "fetchServer": "",
                        "fetchServerPort": "",
                        "fetchProtocol": "",
                        "fetchssl": "true",
                        "smtpServer": null,
                        "smtpServerPort": "",
                        "smtpAuthenticated": "",
                        "smtpssl": "true",
                        "name": "测试"
                    },
                    "valid": 1,
                    "orderByNo": 0,
                    "weixinDeptId": "4",
                    "lanxinDeptId": null,
                    "field1": null,
                    "field2": null,
                    "field3": null,
                    "field4": null,
                    "field5": null,
                    "field6": null,
                    "field7": null,
                    "field8": null,
                    "field9": null,
                    "field10": null,
                    "fieldExtendsValues": []
                }
        ],
        "pageCount": 3
    }
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 企业域集合               |
| data[0].id   | 企业域id                 |
| data[0].name | 企业域名称               |

### 3.6删除部门

**请求方式：** DELETE
**请求地址：** /api/authtime/department

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
|        |    |          |

**请求包体**：

```
 [
    "ID1",
    "ID2",
    "ID3"
]

```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "删除成功"
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 企业域集合               |
| data[0].id   | 企业域id                 |
| data[0].name | 企业域名称               |

### 3.7部门下用户

**请求方式：** GET
**请求地址：** /api/authtime/department/{departmentid}/users?pagelines={pagelines}&currpage={currpage}

**参数说明：**

| **参数**     | **必须** | **说明** |
| ------------ | -------- | -------- |
| departmentid | 是       | 部门id   |
| pagelines    | 否       | 页长     |
| currpage     | 否       | 当前页   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 72,
        "linesPerPage": 10,
        "pageNo": 1,
        "datas": [
            {
                "domainid": "3CffNlgt9B9StIjIUPB",
                "id": "0JyBHSIZPmSOQpQwd1K",
                "name": "宣传j",
                "nameLetter": "xcj",
                "loginno": "janxuanchuan",
                "loginpwd": "a7f5315eb4515985c48a221eda34b1b47d223d3ea4dab502",
                "email": "1023495931@qq.com",
                "calendarType": "ZKsRAyDrAP7u0NKPQdR",
                "status": 1,
                "telephone": "",
                "superAdmin": false,
                "developer": false,
                "defaultApplication": "HdPeBqYwJyFyjHkhZu3",
                "defaultDepartment": "Z42xU8LmniRouZ93E7s",
                "domainPermission": 0,
                "superior": {
                    "domainid": "3CffNlgt9B9StIjIUPB",
                    "id": "bKsXwPeEiG9GI8BKKNd",
                    "name": "主管j",
                    "nameLetter": "zgj",
                    "loginno": "janzhuguan",
                    "loginpwd": "2b2ff802862b41f74aa3359e90586c36c573afea7f43af85",
                    "email": "",
                    "calendarType": "ZKsRAyDrAP7u0NKPQdR",
                    "status": 1,
                    "telephone": "",
                    "superAdmin": false,
                    "developer": false,
                    "defaultApplication": "HdPeBqYwJyFyjHkhZu3",
                    "defaultDepartment": "Z42xU8LmniRouZ93E7s",
                    "domainPermission": 0,
                    "superior": null,
                    "passwordArray": null,
                    "lockFlag": 1,
                    "publicKey": null,
                    "avatar": "",
                    "favoriteContacts": "",
                    "liaisonOfficer": false,
                    "permissionType": "public",
                    "telephone2": "",
                    "telephonePublic": true,
                    "telephonePublic2": true,
                    "emailPublic": true,
                    "userInfoPublic": true,
                    "signs": "",
                    "level": 0,
                    "roles": [
                        {
                            "id": "kPLbeydkgiYW6NIkCt0",
                            "name": "主管",
                            "roleNo": "1002",
                            "status": 1,
                            "defaultRole": true,
                            "sortId": null,
                            "permission": null
                        }
                    ],
                    "remarks": null,
                    "departments": [
                        {
                            "id": "Z42xU8LmniRouZ93E7s",
                            "name": "测试",
                            "superior": null,
                            "code": "1",
                            "level": 0,
                            "indexCode": "5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s",
                            "domain": {
                                "id": "3CffNlgt9B9StIjIUPB",
                                "sendHost": "191.91.919.1",
                                "sendAddress": "123@1.com",
                                "sendAccount": "admin",
                                "sendPassword": "123456",
                                "ccAddress": "234@1.com",
                                "isUseClient": "true",
                                "functionDomain": "",
                                "trash": null,
                                "sender": "",
                                "draft": "",
                                "removed": "",
                                "fetchServer": "",
                                "fetchServerPort": "",
                                "fetchProtocol": "",
                                "fetchssl": "true",
                                "smtpServer": null,
                                "smtpServerPort": "",
                                "smtpAuthenticated": "",
                                "smtpssl": "true",
                                "name": "测试"
                            },
                            "valid": 1,
                            "orderByNo": 0,
                            "weixinDeptId": "1",
                            "lanxinDeptId": "",
                            "field1": null,
                            "field2": null,
                            "field3": null,
                            "field4": null,
                            "field5": null,
                            "field6": null,
                            "field7": null,
                            "field8": null,
                            "field9": null,
                            "field10": null,
                            "fieldExtendsValues": []
                        }
                    ],
                    "userDepartmentRoleSets": [
                        {
                            "id": "4028d8c667efe51b0167f297e6b30005",
                            "userId": "bKsXwPeEiG9GI8BKKNd",
                            "roleId": "kPLbeydkgiYW6NIkCt0",
                            "departmentId": "Z42xU8LmniRouZ93E7s"
                        }
                    ],
                    "domainUser": "false",
                    "useIM": false,
                    "orderByNo": 0,
                    "dimission": 1,
                    "proxyUser": null,
                    "field1": null,
                    "field2": null,
                    "field3": null,
                    "field4": null,
                    "field5": null,
                    "field6": null,
                    "field7": null,
                    "field8": null,
                    "field9": null,
                    "field10": null,
                    "pwdErrorTimes": 0,
                    "fieldExtendsValues": [],
                    "roleDepartments": [
                        {
                            "roleId": "kPLbeydkgiYW6NIkCt0",
                            "roleName": "主管",
                            "applicationId": "HdPeBqYwJyFyjHkhZu3",
                            "departmentName": null,
                            "departmentId": "Z42xU8LmniRouZ93E7s"
                        }
                    ],
                    "userSkin": "good",
                    "userStyle": null,
                    "useHomePage": null,
                    "pendingStyle": null,
                    "generalPage": null,
                    "configure": null,
                    "commonOpinion": "[{\"id\":\"720620ab-5f19-4741-bdf0-8cab8e3bfe5b\",\"content\":\"同意\"},{\"id\":\"a3ddc172-49e3-4517-91b0-bbe8c3b8a31f\",\"content\":\"批准\"},{\"id\":\"1c5bd442-4d44-44c9-bb54-40360eef5828\",\"content\":\"OK\"}]",
                    "superiorList": []
                },
                "passwordArray": null,
                "lockFlag": 1,
                "publicKey": null,
                "avatar": "",
                "favoriteContacts": "",
                "liaisonOfficer": false,
                "permissionType": "public",
                "telephone2": "",
                "telephonePublic": true,
                "telephonePublic2": true,
                "emailPublic": true,
                "userInfoPublic": true,
                "signs": "",
                "level": 1,
                "roles": [
                    {
                        "id": "SYsIw51stcCwm7fVYYs",
                        "name": "宣传部",
                        "roleNo": "1006",
                        "status": 1,
                        "defaultRole": true,
                        "sortId": null,
                        "permission": null
                    }
                ],
                "remarks": "",
                "departments": [
                    {
                        "id": "Z42xU8LmniRouZ93E7s",
                        "name": "测试",
                        "superior": null,
                        "code": "1",
                        "level": 0,
                        "indexCode": "5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s",
                        "domain": {
                            "id": "3CffNlgt9B9StIjIUPB",
                            "sendHost": "191.91.919.1",
                            "sendAddress": "123@1.com",
                            "sendAccount": "admin",
                            "sendPassword": "123456",
                            "ccAddress": "234@1.com",
                            "isUseClient": "true",
                            "functionDomain": "",
                            "trash": null,
                            "sender": "",
                            "draft": "",
                            "removed": "",
                            "fetchServer": "",
                            "fetchServerPort": "",
                            "fetchProtocol": "",
                            "fetchssl": "true",
                            "smtpServer": null,
                            "smtpServerPort": "",
                            "smtpAuthenticated": "",
                            "smtpssl": "true",
                            "name": "测试"
                        },
                        "valid": 1,
                        "orderByNo": 0,
                        "weixinDeptId": "1",
                        "lanxinDeptId": "",
                        "field1": null,
                        "field2": null,
                        "field3": null,
                        "field4": null,
                        "field5": null,
                        "field6": null,
                        "field7": null,
                        "field8": null,
                        "field9": null,
                        "field10": null,
                        "fieldExtendsValues": []
                    }
                ],
                "userDepartmentRoleSets": [
                    {
                        "id": "40288a036d5c36e8016d5da3a8ad0005",
                        "userId": "0JyBHSIZPmSOQpQwd1K",
                        "roleId": "SYsIw51stcCwm7fVYYs",
                        "departmentId": "Z42xU8LmniRouZ93E7s"
                    }
                ],
                "domainUser": null,
                "useIM": false,
                "orderByNo": 0,
                "dimission": 1,
                "proxyUser": null,
                "field1": null,
                "field2": null,
                "field3": null,
                "field4": null,
                "field5": null,
                "field6": null,
                "field7": null,
                "field8": null,
                "field9": null,
                "field10": null,
                "pwdErrorTimes": 0,
                "fieldExtendsValues": [],
                "roleDepartments": [
                    {
                        "roleId": "SYsIw51stcCwm7fVYYs",
                        "roleName": "宣传部",
                        "applicationId": "HdPeBqYwJyFyjHkhZu3",
                        "departmentName": null,
                        "departmentId": "Z42xU8LmniRouZ93E7s"
                    }
                ],
                "userSkin": null,
                "userStyle": null,
                "useHomePage": null,
                "pendingStyle": null,
                "generalPage": null,
                "configure": null,
                "commonOpinion": null,
                "superiorList": [
                    {
                        "domainid": "3CffNlgt9B9StIjIUPB",
                        "id": "bKsXwPeEiG9GI8BKKNd",
                        "name": "主管j",
                        "nameLetter": "zgj",
                        "loginno": "janzhuguan",
                        "loginpwd": "2b2ff802862b41f74aa3359e90586c36c573afea7f43af85",
                        "email": "",
                        "calendarType": "ZKsRAyDrAP7u0NKPQdR",
                        "status": 1,
                        "telephone": "",
                        "superAdmin": false,
                        "developer": false,
                        "defaultApplication": "HdPeBqYwJyFyjHkhZu3",
                        "defaultDepartment": "Z42xU8LmniRouZ93E7s",
                        "domainPermission": 0,
                        "superior": null,
                        "passwordArray": null,
                        "lockFlag": 1,
                        "publicKey": null,
                        "avatar": "",
                        "favoriteContacts": "",
                        "liaisonOfficer": false,
                        "permissionType": "public",
                        "telephone2": "",
                        "telephonePublic": true,
                        "telephonePublic2": true,
                        "emailPublic": true,
                        "userInfoPublic": true,
                        "signs": "",
                        "level": 0,
                        "roles": [
                            {
                                "id": "kPLbeydkgiYW6NIkCt0",
                                "name": "主管",
                                "roleNo": "1002",
                                "status": 1,
                                "defaultRole": true,
                                "sortId": null,
                                "permission": null
                            }
                        ],
                        "remarks": null,
                        "departments": [
                            {
                                "id": "Z42xU8LmniRouZ93E7s",
                                "name": "测试",
                                "superior": null,
                                "code": "1",
                                "level": 0,
                                "indexCode": "5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s",
                                "domain": {
                                    "id": "3CffNlgt9B9StIjIUPB",
                                    "sendHost": "191.91.919.1",
                                    "sendAddress": "123@1.com",
                                    "sendAccount": "admin",
                                    "sendPassword": "123456",
                                    "ccAddress": "234@1.com",
                                    "isUseClient": "true",
                                    "functionDomain": "",
                                    "trash": null,
                                    "sender": "",
                                    "draft": "",
                                    "removed": "",
                                    "fetchServer": "",
                                    "fetchServerPort": "",
                                    "fetchProtocol": "",
                                    "fetchssl": "true",
                                    "smtpServer": null,
                                    "smtpServerPort": "",
                                    "smtpAuthenticated": "",
                                    "smtpssl": "true",
                                    "name": "测试"
                                },
                                "valid": 1,
                                "orderByNo": 0,
                                "weixinDeptId": "1",
                                "lanxinDeptId": "",
                                "field1": null,
                                "field2": null,
                                "field3": null,
                                "field4": null,
                                "field5": null,
                                "field6": null,
                                "field7": null,
                                "field8": null,
                                "field9": null,
                                "field10": null,
                                "fieldExtendsValues": []
                            }
                        ],
                        "userDepartmentRoleSets": [
                            {
                                "id": "4028d8c667efe51b0167f297e6b30005",
                                "userId": "bKsXwPeEiG9GI8BKKNd",
                                "roleId": "kPLbeydkgiYW6NIkCt0",
                                "departmentId": "Z42xU8LmniRouZ93E7s"
                            }
                        ],
                        "domainUser": "false",
                        "useIM": false,
                        "orderByNo": 0,
                        "dimission": 1,
                        "proxyUser": null,
                        "field1": null,
                        "field2": null,
                        "field3": null,
                        "field4": null,
                        "field5": null,
                        "field6": null,
                        "field7": null,
                        "field8": null,
                        "field9": null,
                        "field10": null,
                        "pwdErrorTimes": 0,
                        "fieldExtendsValues": [],
                        "roleDepartments": [
                            {
                                "roleId": "kPLbeydkgiYW6NIkCt0",
                                "roleName": "主管",
                                "applicationId": "HdPeBqYwJyFyjHkhZu3",
                                "departmentName": null,
                                "departmentId": "Z42xU8LmniRouZ93E7s"
                            }
                        ],
                        "userSkin": "good",
                        "userStyle": null,
                        "useHomePage": null,
                        "pendingStyle": null,
                        "generalPage": null,
                        "configure": null,
                        "commonOpinion": "[{\"id\":\"720620ab-5f19-4741-bdf0-8cab8e3bfe5b\",\"content\":\"同意\"},{\"id\":\"a3ddc172-49e3-4517-91b0-bbe8c3b8a31f\",\"content\":\"批准\"},{\"id\":\"1c5bd442-4d44-44c9-bb54-40360eef5828\",\"content\":\"OK\"}]",
                        "superiorList": []
                    }
                ]
            },
        "pageCount": 8
    }
}
```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 企业域集合               |
| data[0].id   | 企业域id                 |
| data[0].name | 企业域名称               |

### 3.8部门导入

**请求方式：** POST
**请求地址：** /api/authtime/domain/{domainid}/department/import?path={path}

**参数说明：**

| **参数** | **必须** | **说明**                                   |
| -------- | -------- | ------------------------------------------ |
| domainid | 是       | 企业域id                                   |
| path     | 是       | excel文件路径（/upload/..../部门列表.xls） |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
    	"第几行有什么错误！"
    ]
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 错误信息                 |

## 4.  **用户**

### 4.1查询企业域用户列表

**请求方式：** POST  
**请求地址：** /api/authtime/domain/{domainid}/users?

departmentid={departmentid}&orderby={orderby}&currpage={currpage}&

lines={lines} 

**参数说明：**  补充按部门查找--Jarod

| **参数**      | **必须** | **说明**                      |
| :------------ | -------- | ----------------------------- |
| name          | 否       | 用户名                        |
| applicationid | 否       | 软件id  //不应该存在哦--Jarod |
| loginno       | 否       | 用户账号                      |
| roleid        | 否       | 角色id                        |
| superiorname  | 否       | 上级名称                      |
| departmentid  | 否       | 部门id                        |
| orderby       | 否       | 排序字段                      |
| currpage      | 是       | 当前页码                      |
| lines         | 是       | 页大小                        |
| domainid      | 是       | 企业域id                      |

**请求包体：**

{
  	"name": "用户名称",

​	"loginno" : "用户账号",

​	"superiorname” : “上级名称”,

​	“applicationid“ : ”软件id ”,

​	”roleid“ : ”角色id“

}

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 1,
        "linesPerPage": 10,
        "pageNo": 1,
        "datas": [
            {
                "domainid": "3CffNlgt9B9StIjIUPB",
                "id": "zPsp2hk7CEwtqeMCwtj",
                "name": "管理员",
                "nameLetter": "gly",
                "loginno": "admin1",
                "loginpwd": "bf60e0beafc1cee542dccbbe4d2e7cd61f267cb8aa8e1ce4",
                "email": "testHca5XjUsStAGGXkdoh2@teemlink.com",
                "calendarType": "8gCbTPSmbLJD6geyumJ",
                "status": 1,
                "telephone": "13612221222",
                "superAdmin": false,
                "developer": false,
                "defaultApplication": "HdPeBqYwJyFyjHkhZu3",
                "defaultDepartment": "Z42xU8LmniRouZ93E7s",
                "domainPermission": 0,
                "superior": null,
                "passwordArray": null,
                "lockFlag": 1(0为锁定，1为未锁定),
                "publicKey": null,
                "avatar": "",
                "favoriteContacts": "",
                "liaisonOfficer": false,
                "permissionType": "public",
                "telephone2": "",
                "telephonePublic": true,
                "telephonePublic2": true,
                "emailPublic": true,
                "userInfoPublic": true,
                "signs": "",
                "level": 0,
                "roles": [
                    {
                        "id": "2jSs6cnzu4mzY9C13vF",
                        "name": "员工",
                        "roleNo": "5",
                        "status": 1,
                        "defaultRole": true,
                        "sortId": null,
                        "permission": null
                    },
                    {
                        "id": "SYsIw51stcCwm7fVYYs",
                        "name": "宣传部",
                        "roleNo": "1006",
                        "status": 1,
                        "defaultRole": true,
                        "sortId": null,
                        "permission": null
                    },
                    {
                        "id": "2ytUeoxBqghwofmBALl",
                        "name": "办公室",
                        "roleNo": "1005",
                        "status": 1,
                        "defaultRole": true,
                        "sortId": null,
                        "permission": null
                    },
                    {
                        "id": "3tFw1boS5L9vXoJCr6Z",
                        "name": "管理员",
                        "roleNo": "6",
                        "status": 1,
                        "defaultRole": true,
                        "sortId": null,
                        "permission": null
                    },
                    {
                        "id": "0Q0LkJpfR1ejtO8rD3p",
                        "name": "人事",
                        "roleNo": "1004",
                        "status": 1,
                        "defaultRole": true,
                        "sortId": null,
                        "permission": null
                    },
                    {
                        "id": "kPLbeydkgiYW6NIkCt0",
                        "name": "主管",
                        "roleNo": "1002",
                        "status": 1,
                        "defaultRole": true,
                        "sortId": null,
                        "permission": null
                    }
                ],
                "remarks": null,
                "departments": [
                    {
                        "id": "Z42xU8LmniRouZ93E7s",
                        "name": "测试",
                        "superior": null,
                        "code": "1",
                        "level": 0,
                        "indexCode": "5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s",
                        "domain": {
                            "id": "3CffNlgt9B9StIjIUPB",
                            "sendHost": "191.91.919.1",
                            "sendAddress": "123@1.com",
                            "sendAccount": "admin",
                            "sendPassword": "123456",
                            "ccAddress": "234@1.com",
                            "isUseClient": "true",
                            "functionDomain": "",
                            "trash": null,
                            "sender": "",
                            "draft": "",
                            "removed": "",
                            "fetchServer": "",
                            "fetchServerPort": "",
                            "fetchProtocol": "",
                            "fetchssl": "true",
                            "smtpServer": null,
                            "smtpServerPort": "",
                            "smtpAuthenticated": "",
                            "smtpssl": "true",
                            "name": "测试"
                        },
                        "valid": 1,
                        "orderByNo": 0,
                        "weixinDeptId": "1",
                        "lanxinDeptId": "",
                        "field1": null,
                        "field2": null,
                        "field3": null,
                        "field4": null,
                        "field5": null,
                        "field6": null,
                        "field7": null,
                        "field8": null,
                        "field9": null,
                        "field10": null,
                        "fieldExtendsValues": []
                    }
                ],
                "userDepartmentRoleSets": [
                    {
                        "id": "4028d83e6ae26a40016ae393d1fc0037",
                        "userId": "zPsp2hk7CEwtqeMCwtj",
                        "roleId": "kPLbeydkgiYW6NIkCt0",
                        "departmentId": "Z42xU8LmniRouZ93E7s"
                    },
                    {
                        "id": "4028d83e6ae26a40016ae393d1fc003a",
                        "userId": "zPsp2hk7CEwtqeMCwtj",
                        "roleId": "3tFw1boS5L9vXoJCr6Z",
                        "departmentId": "Z42xU8LmniRouZ93E7s"
                    },
                    {
                        "id": "4028d83e6ae26a40016ae393d1fc0031",
                        "userId": "zPsp2hk7CEwtqeMCwtj",
                        "roleId": "2ytUeoxBqghwofmBALl",
                        "departmentId": "Z42xU8LmniRouZ93E7s"
                    },
                    {
                        "id": "4028d83e6ae26a40016ae393d1fc0038",
                        "userId": "zPsp2hk7CEwtqeMCwtj",
                        "roleId": "SYsIw51stcCwm7fVYYs",
                        "departmentId": "Z42xU8LmniRouZ93E7s"
                    },
                    {
                        "id": "4028d83e6ae26a40016ae393d1fc0035",
                        "userId": "zPsp2hk7CEwtqeMCwtj",
                        "roleId": "2jSs6cnzu4mzY9C13vF",
                        "departmentId": "Z42xU8LmniRouZ93E7s"
                    },
                    {
                        "id": "4028d83e6ae26a40016ae393d1fc0033",
                        "userId": "zPsp2hk7CEwtqeMCwtj",
                        "roleId": "0Q0LkJpfR1ejtO8rD3p",
                        "departmentId": "Z42xU8LmniRouZ93E7s"
                    },
                    {
                        "id": "4028d83e6ae26a40016ae393d1fc0039",
                        "userId": "zPsp2hk7CEwtqeMCwtj",
                        "roleId": "0Q0LkJpfR1ejtO8rD3p",
                        "departmentId": "Z42xU8LmniRouZ93E7s"
                    },
                    {
                        "id": "4028d83e6ae26a40016ae393d1fc0030",
                        "userId": "zPsp2hk7CEwtqeMCwtj",
                        "roleId": "SYsIw51stcCwm7fVYYs",
                        "departmentId": "Z42xU8LmniRouZ93E7s"
                    },
                    {
                        "id": "4028d83e6ae26a40016ae393d1fc0032",
                        "userId": "zPsp2hk7CEwtqeMCwtj",
                        "roleId": "3tFw1boS5L9vXoJCr6Z",
                        "departmentId": "Z42xU8LmniRouZ93E7s"
                    },
                    {
                        "id": "4028d83e6ae26a40016ae393d1fc002f",
                        "userId": "zPsp2hk7CEwtqeMCwtj",
                        "roleId": "2jSs6cnzu4mzY9C13vF",
                        "departmentId": "Z42xU8LmniRouZ93E7s"
                    },
                    {
                        "id": "4028d83e6ae26a40016ae393d1fc0034",
                        "userId": "zPsp2hk7CEwtqeMCwtj",
                        "roleId": "kPLbeydkgiYW6NIkCt0",
                        "departmentId": "Z42xU8LmniRouZ93E7s"
                    },
                    {
                        "id": "4028d83e6ae26a40016ae393d1fc0036",
                        "userId": "zPsp2hk7CEwtqeMCwtj",
                        "roleId": "2ytUeoxBqghwofmBALl",
                        "departmentId": "Z42xU8LmniRouZ93E7s"
                    }
                ],
                "domainUser": "true",
                "useIM": false,
                "orderByNo": 0,
                "dimission": 1,
                "proxyUser": null,
                "field1": null,
                "field2": null,
                "field3": null,
                "field4": null,
                "field5": null,
                "field6": null,
                "field7": null,
                "field8": null,
                "field9": null,
                "field10": null,
                "pwdErrorTimes": 0,
                "fieldExtendsValues": [],
                "roleDepartments": [
                    {
                        "roleId": "kPLbeydkgiYW6NIkCt0",
                        "roleName": "主管",
                        "applicationId": "HdPeBqYwJyFyjHkhZu3",
                        "departmentName": null,
                        "departmentId": "Z42xU8LmniRouZ93E7s"
                    },
                    {
                        "roleId": "3tFw1boS5L9vXoJCr6Z",
                        "roleName": "管理员",
                        "applicationId": "HdPeBqYwJyFyjHkhZu3",
                        "departmentName": null,
                        "departmentId": "Z42xU8LmniRouZ93E7s"
                    },
                    {
                        "roleId": "2ytUeoxBqghwofmBALl",
                        "roleName": "办公室",
                        "applicationId": "HdPeBqYwJyFyjHkhZu3",
                        "departmentName": null,
                        "departmentId": "Z42xU8LmniRouZ93E7s"
                    },
                    {
                        "roleId": "SYsIw51stcCwm7fVYYs",
                        "roleName": "宣传部",
                        "applicationId": "HdPeBqYwJyFyjHkhZu3",
                        "departmentName": null,
                        "departmentId": "Z42xU8LmniRouZ93E7s"
                    },
                    {
                        "roleId": "2jSs6cnzu4mzY9C13vF",
                        "roleName": "员工",
                        "applicationId": "HdPeBqYwJyFyjHkhZu3",
                        "departmentName": null,
                        "departmentId": "Z42xU8LmniRouZ93E7s"
                    },
                    {
                        "roleId": "0Q0LkJpfR1ejtO8rD3p",
                        "roleName": "人事",
                        "applicationId": "HdPeBqYwJyFyjHkhZu3",
                        "departmentName": null,
                        "departmentId": "Z42xU8LmniRouZ93E7s"
                    },
                    {
                        "roleId": "0Q0LkJpfR1ejtO8rD3p",
                        "roleName": "人事",
                        "applicationId": "HdPeBqYwJyFyjHkhZu3",
                        "departmentName": null,
                        "departmentId": "Z42xU8LmniRouZ93E7s"
                    },
                    {
                        "roleId": "SYsIw51stcCwm7fVYYs",
                        "roleName": "宣传部",
                        "applicationId": "HdPeBqYwJyFyjHkhZu3",
                        "departmentName": null,
                        "departmentId": "Z42xU8LmniRouZ93E7s"
                    },
                    {
                        "roleId": "3tFw1boS5L9vXoJCr6Z",
                        "roleName": "管理员",
                        "applicationId": "HdPeBqYwJyFyjHkhZu3",
                        "departmentName": null,
                        "departmentId": "Z42xU8LmniRouZ93E7s"
                    },
                    {
                        "roleId": "2jSs6cnzu4mzY9C13vF",
                        "roleName": "员工",
                        "applicationId": "HdPeBqYwJyFyjHkhZu3",
                        "departmentName": null,
                        "departmentId": "Z42xU8LmniRouZ93E7s"
                    },
                    {
                        "roleId": "kPLbeydkgiYW6NIkCt0",
                        "roleName": "主管",
                        "applicationId": "HdPeBqYwJyFyjHkhZu3",
                        "departmentName": null,
                        "departmentId": "Z42xU8LmniRouZ93E7s"
                    },
                    {
                        "roleId": "2ytUeoxBqghwofmBALl",
                        "roleName": "办公室",
                        "applicationId": "HdPeBqYwJyFyjHkhZu3",
                        "departmentName": null,
                        "departmentId": "Z42xU8LmniRouZ93E7s"
                    }
                ],
                "userSkin": "good",
                "userStyle": null,
                "useHomePage": null,
                "pendingStyle": null,
                "generalPage": null,
                "configure": null,
                "commonOpinion": "[{\"id\":\"75b89d59-01ca-4536-96c8-b01e2e1fbb71\",\"content\":\"同意\"},{\"id\":\"0f08a08b-001c-4b76-9b01-8e450ddd8d70\",\"content\":\"批准\"},{\"id\":\"a6c7b1d5-7e4b-4b9f-8f4d-4b30d71d6811\",\"content\":\"OK\"}]",
                "superiorList": [],
                "manageDepartmentList": [
                    {
                        "id": "Z42xU8LmniRouZ93E7s",
                        "name": "测试",
                        "superior": null,
                        "code": "1",
                        "level": 0,
                        "indexCode": "5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s",
                        "domain": {
                            "id": "3CffNlgt9B9StIjIUPB",
                            "sendHost": "191.91.919.1",
                            "sendAddress": "123@1.com",
                            "sendAccount": "admin",
                            "sendPassword": "123456",
                            "ccAddress": "234@1.com",
                            "isUseClient": "true",
                            "functionDomain": "",
                            "trash": null,
                            "sender": "",
                            "draft": "",
                            "removed": "",
                            "fetchServer": "",
                            "fetchServerPort": "",
                            "fetchProtocol": "",
                            "fetchssl": "true",
                            "smtpServer": null,
                            "smtpServerPort": "",
                            "smtpAuthenticated": "",
                            "smtpssl": "true",
                            "name": "测试"
                        },
                        "valid": 1,
                        "orderByNo": 0,
                        "weixinDeptId": "1",
                        "lanxinDeptId": "",
                        "field1": null,
                        "field2": null,
                        "field3": null,
                        "field4": null,
                        "field5": null,
                        "field6": null,
                        "field7": null,
                        "field8": null,
                        "field9": null,
                        "field10": null,
                        "fieldExtendsValues": []
                    }
                ],
                "interfaceDepartmentList": [
                    {
                        "id": "Z42xU8LmniRouZ93E7s",
                        "name": "测试",
                        "superior": null,
                        "code": "1",
                        "level": 0,
                        "indexCode": "5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s",
                        "domain": {
                            "id": "3CffNlgt9B9StIjIUPB",
                            "sendHost": "191.91.919.1",
                            "sendAddress": "123@1.com",
                            "sendAccount": "admin",
                            "sendPassword": "123456",
                            "ccAddress": "234@1.com",
                            "isUseClient": "true",
                            "functionDomain": "",
                            "trash": null,
                            "sender": "",
                            "draft": "",
                            "removed": "",
                            "fetchServer": "",
                            "fetchServerPort": "",
                            "fetchProtocol": "",
                            "fetchssl": "true",
                            "smtpServer": null,
                            "smtpServerPort": "",
                            "smtpAuthenticated": "",
                            "smtpssl": "true",
                            "name": "测试"
                        },
                        "valid": 1,
                        "orderByNo": 0,
                        "weixinDeptId": "1",
                        "lanxinDeptId": "",
                        "field1": null,
                        "field2": null,
                        "field3": null,
                        "field4": null,
                        "field5": null,
                        "field6": null,
                        "field7": null,
                        "field8": null,
                        "field9": null,
                        "field10": null,
                        "fieldExtendsValues": []
                    }
                ]
            }
        ],
        "pageCount": 1
    }
}
```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 企业域集合               |
| data[0].id   | 企业域id                 |
| data[0].name | 企业域名称               |

### 4.2获取用户详情

**请求方式：** GET  
**请求地址：** /api/authtime/user/{id}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| id       | 是       |     用户id     |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "domainid": "3CffNlgt9B9StIjIUPB",
        "id": "zPsp2hk7CEwtqeMCwtj",
        "name": "管理员",
        "nameLetter": "gly",
        "loginno": "admin1",
        "loginpwd": "bf60e0beafc1cee542dccbbe4d2e7cd61f267cb8aa8e1ce4",
        "email": "testHca5XjUsStAGGXkdoh2@teemlink.com",
        "calendarType": "8gCbTPSmbLJD6geyumJ",
        "status": 1,
        "telephone": "13612221222",
        "superAdmin": false,
        "developer": false,
        "defaultApplication": "HdPeBqYwJyFyjHkhZu3",
        "defaultDepartment": "Z42xU8LmniRouZ93E7s",
        "domainPermission": 0,
        "superior": null,
        "passwordArray": null,
        "lockFlag": 1(0为锁定，1为未锁定),
        "publicKey": null,
        "avatar": "",
        "favoriteContacts": "",
        "liaisonOfficer": false,
        "permissionType": "public",
        "telephone2": "",
        "telephonePublic": true,
        "telephonePublic2": true,
        "emailPublic": true,
        "userInfoPublic": true,
        "signs": "",
        "level": 0,
        "roles": [
            {
                "id": "2jSs6cnzu4mzY9C13vF",
                "name": "员工",
                "roleNo": "5",
                "status": 1,
                "defaultRole": true,
                "sortId": null,
                "permission": null
            },
            {
                "id": "SYsIw51stcCwm7fVYYs",
                "name": "宣传部",
                "roleNo": "1006",
                "status": 1,
                "defaultRole": true,
                "sortId": null,
                "permission": null
            },
            {
                "id": "2ytUeoxBqghwofmBALl",
                "name": "办公室",
                "roleNo": "1005",
                "status": 1,
                "defaultRole": true,
                "sortId": null,
                "permission": null
            },
            {
                "id": "3tFw1boS5L9vXoJCr6Z",
                "name": "管理员",
                "roleNo": "6",
                "status": 1,
                "defaultRole": true,
                "sortId": null,
                "permission": null
            },
            {
                "id": "0Q0LkJpfR1ejtO8rD3p",
                "name": "人事",
                "roleNo": "1004",
                "status": 1,
                "defaultRole": true,
                "sortId": null,
                "permission": null
            },
            {
                "id": "kPLbeydkgiYW6NIkCt0",
                "name": "主管",
                "roleNo": "1002",
                "status": 1,
                "defaultRole": true,
                "sortId": null,
                "permission": null
            }
        ],
        "remarks": null,
        "departments": [
            {
                "id": "Z42xU8LmniRouZ93E7s",
                "name": "测试",
                "superior": null,
                "code": "1",
                "level": 0,
                "indexCode": "5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s",
                "domain": {
                    "id": "3CffNlgt9B9StIjIUPB",
                    "sendHost": "191.91.919.1",
                    "sendAddress": "123@1.com",
                    "sendAccount": "admin",
                    "sendPassword": "123456",
                    "ccAddress": "234@1.com",
                    "isUseClient": "true",
                    "functionDomain": "",
                    "trash": null,
                    "sender": "",
                    "draft": "",
                    "removed": "",
                    "fetchServer": "",
                    "fetchServerPort": "",
                    "fetchProtocol": "",
                    "fetchssl": "true",
                    "smtpServer": null,
                    "smtpServerPort": "",
                    "smtpAuthenticated": "",
                    "smtpssl": "true",
                    "name": "测试"
                },
                "valid": 1,
                "orderByNo": 0,
                "weixinDeptId": "1",
                "lanxinDeptId": "",
                "field1": null,
                "field2": null,
                "field3": null,
                "field4": null,
                "field5": null,
                "field6": null,
                "field7": null,
                "field8": null,
                "field9": null,
                "field10": null,
                "fieldExtendsValues": []
            }
        ],
        "userDepartmentRoleSets": [
            {
                "id": "4028d83e6ae26a40016ae393d1fc0030",
                "userId": "zPsp2hk7CEwtqeMCwtj",
                "roleId": "SYsIw51stcCwm7fVYYs",
                "departmentId": "Z42xU8LmniRouZ93E7s"
            },
            {
                "id": "4028d83e6ae26a40016ae393d1fc0032",
                "userId": "zPsp2hk7CEwtqeMCwtj",
                "roleId": "3tFw1boS5L9vXoJCr6Z",
                "departmentId": "Z42xU8LmniRouZ93E7s"
            },
            {
                "id": "4028d83e6ae26a40016ae393d1fc0035",
                "userId": "zPsp2hk7CEwtqeMCwtj",
                "roleId": "2jSs6cnzu4mzY9C13vF",
                "departmentId": "Z42xU8LmniRouZ93E7s"
            },
            {
                "id": "4028d83e6ae26a40016ae393d1fc0031",
                "userId": "zPsp2hk7CEwtqeMCwtj",
                "roleId": "2ytUeoxBqghwofmBALl",
                "departmentId": "Z42xU8LmniRouZ93E7s"
            },
            {
                "id": "4028d83e6ae26a40016ae393d1fc0037",
                "userId": "zPsp2hk7CEwtqeMCwtj",
                "roleId": "kPLbeydkgiYW6NIkCt0",
                "departmentId": "Z42xU8LmniRouZ93E7s"
            },
            {
                "id": "4028d83e6ae26a40016ae393d1fc0038",
                "userId": "zPsp2hk7CEwtqeMCwtj",
                "roleId": "SYsIw51stcCwm7fVYYs",
                "departmentId": "Z42xU8LmniRouZ93E7s"
            },
            {
                "id": "4028d83e6ae26a40016ae393d1fc002f",
                "userId": "zPsp2hk7CEwtqeMCwtj",
                "roleId": "2jSs6cnzu4mzY9C13vF",
                "departmentId": "Z42xU8LmniRouZ93E7s"
            },
            {
                "id": "4028d83e6ae26a40016ae393d1fc0033",
                "userId": "zPsp2hk7CEwtqeMCwtj",
                "roleId": "0Q0LkJpfR1ejtO8rD3p",
                "departmentId": "Z42xU8LmniRouZ93E7s"
            },
            {
                "id": "4028d83e6ae26a40016ae393d1fc0036",
                "userId": "zPsp2hk7CEwtqeMCwtj",
                "roleId": "2ytUeoxBqghwofmBALl",
                "departmentId": "Z42xU8LmniRouZ93E7s"
            },
            {
                "id": "4028d83e6ae26a40016ae393d1fc003a",
                "userId": "zPsp2hk7CEwtqeMCwtj",
                "roleId": "3tFw1boS5L9vXoJCr6Z",
                "departmentId": "Z42xU8LmniRouZ93E7s"
            },
            {
                "id": "4028d83e6ae26a40016ae393d1fc0034",
                "userId": "zPsp2hk7CEwtqeMCwtj",
                "roleId": "kPLbeydkgiYW6NIkCt0",
                "departmentId": "Z42xU8LmniRouZ93E7s"
            },
            {
                "id": "4028d83e6ae26a40016ae393d1fc0039",
                "userId": "zPsp2hk7CEwtqeMCwtj",
                "roleId": "0Q0LkJpfR1ejtO8rD3p",
                "departmentId": "Z42xU8LmniRouZ93E7s"
            }
        ],
        "domainUser": "true",
        "useIM": false,
        "orderByNo": 0,
        "dimission": 1,
        "proxyUser": null,
        "field1": null,
        "field2": null,
        "field3": null,
        "field4": null,
        "field5": null,
        "field6": null,
        "field7": null,
        "field8": null,
        "field9": null,
        "field10": null,
        "pwdErrorTimes": 0,
        "fieldExtendsValues": [],
        "roleDepartments": [
            {
                "roleId": "SYsIw51stcCwm7fVYYs",
                "roleName": "宣传部",
                "applicationId": "HdPeBqYwJyFyjHkhZu3",
                "departmentName": null,
                "departmentId": "Z42xU8LmniRouZ93E7s"
            },
            {
                "roleId": "3tFw1boS5L9vXoJCr6Z",
                "roleName": "管理员",
                "applicationId": "HdPeBqYwJyFyjHkhZu3",
                "departmentName": null,
                "departmentId": "Z42xU8LmniRouZ93E7s"
            },
            {
                "roleId": "2jSs6cnzu4mzY9C13vF",
                "roleName": "员工",
                "applicationId": "HdPeBqYwJyFyjHkhZu3",
                "departmentName": null,
                "departmentId": "Z42xU8LmniRouZ93E7s"
            },
            {
                "roleId": "2ytUeoxBqghwofmBALl",
                "roleName": "办公室",
                "applicationId": "HdPeBqYwJyFyjHkhZu3",
                "departmentName": null,
                "departmentId": "Z42xU8LmniRouZ93E7s"
            },
            {
                "roleId": "kPLbeydkgiYW6NIkCt0",
                "roleName": "主管",
                "applicationId": "HdPeBqYwJyFyjHkhZu3",
                "departmentName": null,
                "departmentId": "Z42xU8LmniRouZ93E7s"
            },
            {
                "roleId": "SYsIw51stcCwm7fVYYs",
                "roleName": "宣传部",
                "applicationId": "HdPeBqYwJyFyjHkhZu3",
                "departmentName": null,
                "departmentId": "Z42xU8LmniRouZ93E7s"
            },
            {
                "roleId": "2jSs6cnzu4mzY9C13vF",
                "roleName": "员工",
                "applicationId": "HdPeBqYwJyFyjHkhZu3",
                "departmentName": null,
                "departmentId": "Z42xU8LmniRouZ93E7s"
            },
            {
                "roleId": "0Q0LkJpfR1ejtO8rD3p",
                "roleName": "人事",
                "applicationId": "HdPeBqYwJyFyjHkhZu3",
                "departmentName": null,
                "departmentId": "Z42xU8LmniRouZ93E7s"
            },
            {
                "roleId": "2ytUeoxBqghwofmBALl",
                "roleName": "办公室",
                "applicationId": "HdPeBqYwJyFyjHkhZu3",
                "departmentName": null,
                "departmentId": "Z42xU8LmniRouZ93E7s"
            },
            {
                "roleId": "3tFw1boS5L9vXoJCr6Z",
                "roleName": "管理员",
                "applicationId": "HdPeBqYwJyFyjHkhZu3",
                "departmentName": null,
                "departmentId": "Z42xU8LmniRouZ93E7s"
            },
            {
                "roleId": "kPLbeydkgiYW6NIkCt0",
                "roleName": "主管",
                "applicationId": "HdPeBqYwJyFyjHkhZu3",
                "departmentName": null,
                "departmentId": "Z42xU8LmniRouZ93E7s"
            },
            {
                "roleId": "0Q0LkJpfR1ejtO8rD3p",
                "roleName": "人事",
                "applicationId": "HdPeBqYwJyFyjHkhZu3",
                "departmentName": null,
                "departmentId": "Z42xU8LmniRouZ93E7s"
            }
        ],
        "userSkin": "good",
        "userStyle": null,
        "useHomePage": null,
        "pendingStyle": null,
        "generalPage": null,
        "configure": null,
        "commonOpinion": "[{\"id\":\"75b89d59-01ca-4536-96c8-b01e2e1fbb71\",\"content\":\"同意\"},{\"id\":\"0f08a08b-001c-4b76-9b01-8e450ddd8d70\",\"content\":\"批准\"},{\"id\":\"a6c7b1d5-7e4b-4b9f-8f4d-4b30d71d6811\",\"content\":\"OK\"}]",
        "superiorList": [],
        "manageDepartmentList": [
            {
                "id": "Z42xU8LmniRouZ93E7s",
                "name": "测试",
                "superior": null,
                "code": "1",
                "level": 0,
                "indexCode": "5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s",
                "domain": {
                    "id": "3CffNlgt9B9StIjIUPB",
                    "sendHost": "191.91.919.1",
                    "sendAddress": "123@1.com",
                    "sendAccount": "admin",
                    "sendPassword": "123456",
                    "ccAddress": "234@1.com",
                    "isUseClient": "true",
                    "functionDomain": "",
                    "trash": null,
                    "sender": "",
                    "draft": "",
                    "removed": "",
                    "fetchServer": "",
                    "fetchServerPort": "",
                    "fetchProtocol": "",
                    "fetchssl": "true",
                    "smtpServer": null,
                    "smtpServerPort": "",
                    "smtpAuthenticated": "",
                    "smtpssl": "true",
                    "name": "测试"
                },
                "valid": 1,
                "orderByNo": 0,
                "weixinDeptId": "1",
                "lanxinDeptId": "",
                "field1": null,
                "field2": null,
                "field3": null,
                "field4": null,
                "field5": null,
                "field6": null,
                "field7": null,
                "field8": null,
                "field9": null,
                "field10": null,
                "fieldExtendsValues": []
            }
        ],
        "interfaceDepartmentList": [
            {
                "id": "Z42xU8LmniRouZ93E7s",
                "name": "测试",
                "superior": null,
                "code": "1",
                "level": 0,
                "indexCode": "5fbaLCe8DIbIP2BdQoc_Z42xU8LmniRouZ93E7s",
                "domain": {
                    "id": "3CffNlgt9B9StIjIUPB",
                    "sendHost": "191.91.919.1",
                    "sendAddress": "123@1.com",
                    "sendAccount": "admin",
                    "sendPassword": "123456",
                    "ccAddress": "234@1.com",
                    "isUseClient": "true",
                    "functionDomain": "",
                    "trash": null,
                    "sender": "",
                    "draft": "",
                    "removed": "",
                    "fetchServer": "",
                    "fetchServerPort": "",
                    "fetchProtocol": "",
                    "fetchssl": "true",
                    "smtpServer": null,
                    "smtpServerPort": "",
                    "smtpAuthenticated": "",
                    "smtpssl": "true",
                    "name": "测试"
                },
                "valid": 1,
                "orderByNo": 0,
                "weixinDeptId": "1",
                "lanxinDeptId": "",
                "field1": null,
                "field2": null,
                "field3": null,
                "field4": null,
                "field5": null,
                "field6": null,
                "field7": null,
                "field8": null,
                "field9": null,
                "field10": null,
                "fieldExtendsValues": []
            }
        ]
    }
}
```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 企业域集合               |
| data[0].id   | 企业域id                 |
| data[0].name | 企业域名称               |

### 4.4获取指定用户部门角色和km角色关系

**请求方式：** GET  
**请求地址：** /api/authtime/user/{userid}/rolewithdeptandkmrelation

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| userid   | 是       | 用户id   |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "departmentdata": [
            {
                "departmentName": "测试",
                "departmentId": "Z42xU8LmniRouZ93E7s",
                "isDefaultDepartment": true,
                "applicationData": [
                    {
                        "roleData": [
                            {
                                "roleId": "SYsIw51stcCwm7fVYYs",
                                "roleName": "宣传部"
                            },
                            {
                                "roleId": "3tFw1boS5L9vXoJCr6Z",
                                "roleName": "管理员"
                            },
                            {
                                "roleId": "2jSs6cnzu4mzY9C13vF",
                                "roleName": "员工"
                            },
                            {
                                "roleId": "2ytUeoxBqghwofmBALl",
                                "roleName": "办公室"
                            },
                            {
                                "roleId": "kPLbeydkgiYW6NIkCt0",
                                "roleName": "主管"
                            },
                            {
                                "roleId": "SYsIw51stcCwm7fVYYs",
                                "roleName": "宣传部"
                            },
                            {
                                "roleId": "2jSs6cnzu4mzY9C13vF",
                                "roleName": "员工"
                            },
                            {
                                "roleId": "0Q0LkJpfR1ejtO8rD3p",
                                "roleName": "人事"
                            },
                            {
                                "roleId": "2ytUeoxBqghwofmBALl",
                                "roleName": "办公室"
                            },
                            {
                                "roleId": "3tFw1boS5L9vXoJCr6Z",
                                "roleName": "管理员"
                            },
                            {
                                "roleId": "kPLbeydkgiYW6NIkCt0",
                                "roleName": "主管"
                            },
                            {
                                "roleId": "0Q0LkJpfR1ejtO8rD3p",
                                "roleName": "人事"
                            }
                        ],
                        "applicationId": "HdPeBqYwJyFyjHkhZu3",
                        "applicationName": "2.0功能示例"
                    },
                    {
                        "roleData": [],
                        "applicationId": "11de-f053-df18d577-aeb6-19a7865cfdb6",
                        "applicationName": "行政办公"
                    }
                ]
            }
        ],
        "departmentstatu": true,
        "kmdata": [
            {
                "id": "0001",
                "levels": 0,
                "name": "员工"
            },
            {
                "id": "0010",
                "levels": 10,
                "name": "部门知识管理员"
            },
            {
                "id": "0020",
                "levels": 20,
                "name": "专委会知识管理员"
            },
            {
                "id": "0100",
                "levels": 10,
                "name": "企业知识管理员"
            }
        ],
        "kmstatu": true
    }
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 企业域集合               |
| data[0].id   | 企业域id                 |
| data[0].name | 企业域名称               |



### 4.5创建用户

**请求方式：** POST
**请求地址：** /api/authtime/domain/{domainid}/user

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid | 是 | 企业域id |

**请求包体**：

```
{

    "name": "ekko15",

    "loginno": "ekko115",
    
    "loginpwd":"IzNDU2MT",

    "email": "email@teemlink.com",

    "emailPublic": true,

    "telephone": "13192286346",

    "telephonePublic": true,

    "calendarType": "i7xj207zBMEwBp8aATE",

    "calendarTypeName": "夜班日历",

    "telephone2": "13192286349",

    "telephonePublic2": true,

    "reportTree": "",

    "superiorid": "",

    "allUsers": "",

    "_proxyUser": "",

    "remarks": "1111",

    "startProxyTime": "2019-09-30 16:41:01",

    "endProxyTime": "2019-10-11 16:41:04",

    "permissionType": "public",

    "lockFlag": 1,

    "dimission": 1,

    "_strstatus": true,

    "defaultDepartment": "Z42xU8LmniRouZ93E7s",

    "_userRoleDepartmentJson": '[{"roleId":"kPLbeydkgiYW6NIkCt0","departmentId":"Z42xU8LmniRouZ93E7s","applicationId":"HdPeBqYwJyFyjHkhZu3","isDefaultDepartment":"true"}]',

    "_userKMRoleJson": '["KMNORMALROLEID"]',

	"manageDepartments" "Z42xU8LmniRouZ93E7s,Z42xU8LmniRouZ93E7s",
	
	"interfaceDepartments" "Z42xU8LmniRouZ93E7s,Z42xU8LmniRouZ93E7s"
}
```

**权限说明：**

无。

**返回结果：**

```
{
    “errcode”: 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "uuid",
            "name": "无限极公司"
        }
    ]
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 企业域集合               |
| data[0].id   | 企业域id                 |
| data[0].name | 企业域名称               |

### 4.6更新用户

**请求方式：** PUT
**请求地址：**/api/authtime/domain/{domainid}/user/{id}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| id       | 是       | 用户id   |

**请求包体**：

```
{
	"id":"__jpXXK7LJs7EnCb9vZyw",

    "name": "ekko15",

    "loginno": "ekko115",
    
    "loginpwd":"IzNDU2MT",

    "email": "email@teemlink.com",

    "emailPublic": true,

    "telephone": "13192286346",

    "telephonePublic": true,

    "calendarType": "i7xj207zBMEwBp8aATE",

    "calendarTypeName": "夜班日历",

    "telephone2": "13192286349",

    "telephonePublic2": true,

    "reportTree": "",

    "superiorid": "",

    "allUsers": "",

    "_proxyUser": "",

    "remarks": "1111",

    "startProxyTime": "2019-09-30 16:41:01",

    "endProxyTime": "2019-10-11 16:41:04",

    "permissionType": "public",

    "lockFlag": 1,

    "dimission": 1,

    "status": 1,

    "defaultDepartment": "Z42xU8LmniRouZ93E7s",
    
    "departments" : "[{
		"id": "__RgU8FYyXOlqTvun1vR7",
		"name": "2",
		"superior": null,
		"code": "00",
		"level": 0,
		"indexCode": "__RgU8FYyXOlqTvun1vR7",
		"domain": {
			"id": "__t64lurS4a2ZuWARnvcU",
			"sendHost": null,
			"sendAddress": null,
			"sendAccount": null,
			"sendPassword": null,
			"ccAddress": null,
			"isUseClient": null,
			"functionDomain": null,
			"trash": null,
			"sender": null,
			"draft": null,
			"removed": null,
			"fetchServer": null,
			"fetchServerPort": null,
			"fetchProtocol": null,
			"fetchssl": null,
			"smtpServer": null,
			"smtpServerPort": null,
			"smtpAuthenticated": null,
			"smtpssl": null,
			"name": "2",
			"systemName": "",
			"logoUrl": ""
		},
		"valid": 1,
		"orderByNo": 0,
		"weixinDeptId": null,
		"lanxinDeptId": null,
		"dingdingDeptId": null,
		"field1": null,
		"field2": null,
		"field3": null,
		"field4": null,
		"field5": null,
		"field6": null,
		"field7": null,
		"field8": null,
		"field9": null,
		"field10": null,
		"fieldExtendsValues": []
	}]"

    "_userRoleDepartmentJson": '[{"roleId":"kPLbeydkgiYW6NIkCt0","departmentId":"Z42xU8LmniRouZ93E7s","applicationId":"HdPeBqYwJyFyjHkhZu3","isDefaultDepartment":"true"}]',

    "_userKMRoleJson": '["0001"]',

	"manageDepartments" "Z42xU8LmniRouZ93E7s,Z42xU8LmniRouZ93E7s",
	
	"interfaceDepartments" "Z42xU8LmniRouZ93E7s,Z42xU8LmniRouZ93E7s"
}
```

**权限说明：**

无。

**返回结果：**

```
{
    “errcode”: 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "uuid",
            "name": "无限极公司"
        }
    ]
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 企业域集合               |
| data[0].id   | 企业域id                 |
| data[0].name | 企业域名称               |

### 4.7用户删除

**请求方式：** DELETE  
**请求地址：** /api/authtime/user

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
|      |    |          |

**请求包体**：

```
 [
    "ID1",
    "ID2",
    "ID3"
]
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "删除成功"
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 企业域集合               |
| data[0].id   | 企业域id                 |
| data[0].name | 企业域名称               |

### 4.8给角色批量添加用户

**请求方式：** POST  
**请求地址：** /api/authtime/user/batch

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
|          |          |          |

**请求包体**：

```
 {
 	"roleId":"roleId",
 	"deptIds"：[
 		"id1",
 		"id2"
 	],
 	"userIds":[
 		"id1",
 		"id2"
 	]
 }
```

**参数说明：**

| **参数** | **必须** | **说明**   |
| -------- | -------- | ---------- |
| roleId   | 是       | 角色id     |
| deptId   | 是       | 部门id     |
| userIds  | 是       | 用户id集合 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |

### 4.9批量废置用户

**请求方式：** PUT 
**请求地址：** /api/authtime/user/abandonment

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
|          |          |          |

**请求包体**：

```
 [
 	"userId1",
 	"userId2",
 	"userId3"
 ]
```

**参数说明：**

| **参数** | **必须** | **说明**   |
| -------- | -------- | ---------- |
| userId   | 是       | 用户id集合 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "成功"
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |

## 5.角色

### 5.1获取角色列表

**请求方式：** POST  
**请求地址：** /authime/application/{applicationid}/roles?currpage={currpage}&
pagelines={pagelines}

**参数说明：**

| **参数**      | **必须** | **说明**   |
| ------------- | -------- | ---------- |
| applicationid | 是       | 软件id     |
| name          | 否       | 角色名称   |
| currpage      | 否       | 当前页码   |
| pagelines     | 否       | 当前页大小 |

**请求包体：**

{
  	"name": "角色名称"

}

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"role": [{
			"roleId": "0Q0LkJpfR1ejtO8rD3p",
			"roleName": "人事",
			"defaultRole": true
		}],
		"currpage": 1,
		"lines": 2147483647,
		"rowCount": 1
	}
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 角色列表               |
| data[0].id   | 角色id                 |
| data[0].name | 角色名称               |

## 6.  **软件**



### 6.1启用系统软件配置

**请求方式：** PUT
**请求地址：**/api/authtime/domain/{domainid}/defaultapp/{id}/enable

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid | 是       | 企业域id |
| id       | 是       | 软件id   |

**请求包体**：



**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": ""
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 结果                     |



### 6.2禁用系统软件配置

**请求方式：** PUT
**请求地址：**/api/authtime/domain/{domainid}/defaultapp/{id}/disable

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid | 是       | 企业域id |
| id       | 是       | 软件id   |

**请求包体**：



**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": ""
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 结果                     |



### 6.3获取系统软件配置 

**请求方式：** GET  
**请求地址：**/api/authtime/domain/{domainid}/defaultapp

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid | 是   |     企业域id     |



**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": "KMAPPID",
            "name": "知识文档管理",
            "enable": true,
            "realmId": "kmRealm",
            "teamId": "kmTeam",
            "realmEnable": true,
            "teamEnable": false
        },
        {
            "id": "FCAPPID",
            "name": "流程中心",
            "enable": false
        }
    ]
}
```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 软件列表         |
| data[0].id | 软件id |
| data[0].name | 软件名称             |
| data[0].enable | 是否开启               |
| data[0].realmEnable | 是否开启km知识专题模块（专属km） |
| data[0].teamEnable | 是否开启km团队模块（专属km）       |
| data[0].realmId | 知识专题模块id（专属km） |
| data[0].teamId | 团队模块id（专属km） |



### 6.4企业域软件列表

**请求方式：** POST  
**请求地址：**/api/authtime/domain/{domainid}/applications/bind

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid | 是       | 企业域id |
| name     | 否       | 软件名称 |

**请求包体：**

{
  	"name": "软件名称"

}

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 5,
        "linesPerPage": 10,
        "pageNo": 1,
        "datas": [
            {
                "id": "HdPeBqYwJyFyjHkhZu3",
                "name": "2.0功能示例",
                "activated": true
            },
            {
                "id": "dZdmJ6eNvWfLrhhv2yZ",
                "name": "465456",
                "activated": true
            },
            {
                "id": "aaITQNiVuTz324lCKD1",
                "name": "KM",
                "activated": true
            },
            {
                "id": "11e6-429d-dd7a3284-86a2-074015f7cc96",
                "name": "客户管理",
                "activated": true
            },
            {
                "id": "11de-f053-df18d577-aeb6-19a7865cfdb6",
                "name": "行政办公",
                "activated": true
            }
        ],
        "pageCount": 1
    }
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 软件列表               |
| data[0].id   | 软件id                 |
| data[0].name | 软件名称               |
| data[0].activated | 是否激活               |

### 6.5查询未添加软件列表

**请求方式：** POST  
**请求地址：**/api/authtime/domain/{domainid}/applications/unbind

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| name     | 否       | 软件名称 |

**请求包体：**

{
  	"name": "软件名称"

}

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 2,
        "linesPerPage": 10,
        "pageNo": 1,
        "datas": [
            {
                "id": "Q11e7-5f98-d7d66840-917f-e799edecb417",
                "name": "自动化测试系统",
                "activated": true
            },
            {
                "id": "11e7-db36-e48fb673-9ff7-017304b00ed1",
                "name": "功能示例",
                "activated": true
            }
        ],
        "pageCount": 1
    }
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 未添加软件列表               |
| data[0].id   | 企业域id                 |
| data[0].name | 企业域名称               |
| data[0].activated | 是否激活               |

### 6.6移除软件

**请求方式：** DELETE
**请求地址：**/api/authtime/domain/{domainid}/application

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid | 是   |     企业域id     |

**请求包体**：

```
 [
    "软件id",
    "ID2",
    "ID3"
]
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "移除成功"
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 结果               |


### 6.7添加软件

**请求方式：** PUT
**请求地址：**/api/authtime/domain/{domainid}/application

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid    | 是   |     企业域id     |

**请求包体**：

```
[
    "软件id",
    "ID2",
    "ID3"
]
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "添加成功"
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 结果               |

### 6.8保存km角色管理

**请求方式：** PUT
**请求地址：**/api/authtime/domain/{domainid}/savekmconfig

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid | 是       | 企业域id |

**请求包体**：

```
[
    "kmRoleSelectItem"： "0001,0010",
    "ids": "02YPlHf3vAqLaiXQrgh,02YPlHf3vAqLaiXQrgh"
]
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "保存成功"
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     |                          |

### 6.9查询所有软件列表

**请求方式：** GET  
**请求地址：**/api/authtime/applications?name={name}

**参数说明：**

| **参数**  | **必须** | **说明** |
| --------- | -------- | -------- |
| name      | 否       | 软件名称 |
| pagelines | 否       | 页条数   |
| currpage  | 否       | 当前页码 |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 2,
        "linesPerPage": 10,
        "pageNo": 1,
        "datas": [
            {
                "id": "Q11e7-5f98-d7d66840-917f-e799edecb417",
                "name": "自动化测试系统",
                "activated": true
            },
            {
                "id": "11e7-db36-e48fb673-9ff7-017304b00ed1",
                "name": "功能示例",
                "activated": true
            }
        ],
        "pageCount": 1
    }
}

```

**参数说明：**

| **参数**          | **说明**                 |
| ----------------- | ------------------------ |
| errcode           | 返回码（0=成功，1=失败） |
| errmsg            | 对返回码的文本描述内容   |
| data              | 未添加软件列表           |
| data[0].id        | 企业域id                 |
| data[0].name      | 企业域名称               |
| data[0].activated | 是否激活                 |

### 6.10获取KM软件是否开启状态

**请求方式：** GET
**请求地址：**/api/authtime/domain/{domainid}/getkmstatus

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid | 是       | 企业域id |

**请求包体**：

```
无。
```

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"kmstatus": true
	}
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 结果                     |

### 6.11导出角色&菜单权限关系

**请求方式：** GET
**请求地址：**/api/authtime/domain/applications/{applicationid}/exportrolemenuauthority

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| applicationid | 是  | 软件id   |

**请求包体**：

无。

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": "成功"
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 结果                     |

### 6.12导出角色&用户权限关系

**请求方式：** GET
**请求地址：**/api/authtime/domain/{domainid}/applications/{applicationid}/exportroleuserauthority

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| applicationid | 是  | 软件id   |

**请求包体**：

无。

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": "成功"
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 结果                     |

## 7.  **微信配置**

### 7.1微信配置

**请求方式：** GET  
**请求地址：** /api/authtime/domain/{domainid}/wechat

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid | 是   |     企业域id     |

**权限说明：**

无。

**返回结果：**

```
{"errcode":0,"errmsg":"ok","data":{"weixinCorpSecret":"zzz","weixinCorpID":"zzz","weixinProxyType":"EnterpriseWeChat","serverHost":"www","apps":[{"name":"2.0功能示例","weixinAgentId":null,"weixinSecret":null,"description":"2.0功能示例","id":"HdPeBqYwJyFyjHkhZu3"},{"name":"客户管理","weixinAgentId":null,"weixinSecret":null,"description":"客户管理","id":"11e6-429d-dd7a3284-86a2-074015f7cc96"},{"name":"行政办公","weixinAgentId":null,"weixinSecret":null,"description":"OA办公管理系统模板","id":"11de-f053-df18d577-aeb6-19a7865cfdb6"},{"name":"Default","weixinAgentId":null,"weixinSecret":null,"description":"OBPM - Default System","id":"akf5Zsyc9EOtwyOLDOR"},{"name":"任务管理","weixinAgentId":null,"weixinSecret":null,"description":"","id":"pm"},{"name":"调查问卷","weixinAgentId":null,"weixinSecret":null,"description":"","id":"qm"},{"name":"微考勤","weixinAgentId":null,"weixinSecret":null,"description":"","id":"am"},{"name":"联系人管理","weixinAgentId":null,"weixinSecret":null,"description":"","id":"cm"}]}}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 微信配置               |
| data[0].id   | 企业域id                 |
| data[0].name | 企业域名称               |
| data[0].weixinAgentId   | 微信应用AgentId                 |
| data[0].weixinSecret | 微信应用Secret               |
| data[0].description | 企业域描述               |


### 7.2保存微信配置  保存要连同apps配置一并保存  --Jarod

**请求方式：** PUT
**请求地址：** /api/authtime/domain/{domainid}/wechat

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid | 是   |     企业域id     |

**请求包体**：

```
{

    "weixinProxyType": "企业微信号代理方式",

     "weixinCorpID": "微信企业号id",
     
     "weixinCorpSecret": "微信企业号管理组的凭证密钥",
     
     "serverHost": "服务器域名(公网域名)"
     
     
     
     
     "weixinQrCodeAgentId": "微信扫码AgentId"，
     “weixinQrCodeSecret”：“微信扫码Secret”
     “weixinQrCodeCallbackUrl”：“微信扫码CallbackUrl”

}
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "保存成功"
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 结果               |


### 7.3外网访问地址验证

**请求方式：** GET  
**请求地址：** /api/authtime/domain/{domainid}/wechat/corp/{corpid}/corpsecret/{corpsecret}

**参数说明：**

| **参数**   | **必须** | **说明**       |
| ---------- | -------- | -------------- |
| corpid     | 是       | 企业微信CorpID |
| corpsecret | 是       | 通讯录Secret   |
| domainid   | 是       | 企业域id       |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "验证成功"
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 结果               |

### 7.4是否显示企业微信同步到企业域的按钮

**请求方式：** GET  
**请求地址：** /api/authtime/weixin/synchronization/show

**参数说明：**

无

**权限说明：**

无。

**返回结果：**

```
{"errcode":0,"errmsg":"success","data":"true"}
```

true为显示按钮

参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 结果                     |



### 7.5同步企业域组织架构到微信企业号

**请求方式：** PUT
**请求地址：** /api/authtime/domain/{domainid}/synch2wechat

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid | 是   |     企业域id     |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "USER_ADD_SUCCESS": 131,
        "DEPT_ADD_SUCCESS": 60,
        "USER_ADD_FAIL": 60,
        "DEPT_ADD_FAIL": 0,
        "ERRORS": [
            {
                "NAME": "哈登",
                "ERROR": "请校验用户账号、电话、邮箱等数据的规范性",
                "TIP": "missing mobile or email, hint: [1571626602_56_f9b6a4fef27feef3588f7b530c69c14f], from ip: 113.68.195.10, more info at https://open.work.weixin.qq.com/devtool/query?e=60129 user:哈登"
            }]
            }
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 结果               |


### 7.6同步微信企业号组织架构到企业域

**请求方式：** PUT
**请求地址：** /api/authtime/domain/{domainid}/synchfromwechat

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid | 是   |     企业域id     |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "USER_ADD_SUCCESS": 131,
        "DEPT_ADD_SUCCESS": 60,
        "USER_ADD_FAIL": 60,
        "DEPT_ADD_FAIL": 0,
        "ERRORS": [
            {
                "NAME": "哈登",
                "ERROR": "请校验用户账号、电话、邮箱等数据的规范性",
                "TIP": "missing mobile or email, hint: [1571626602_56_f9b6a4fef27feef3588f7b530c69c14f], from ip: 113.68.195.10, more info at https://open.work.weixin.qq.com/devtool/query?e=60129 user:哈登"
            }]
            }
}


```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 结果               |



### 7.7生成跳转链接

**请求方式：** GET  

**请求地址 :******** /api/authtime/domain/{domainid}/application/{applicationid}/getwechaturl

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| domainid      | 是       | 企业域id |
| applicationid | 是       | 软件id   |
|               |          |          |
|               |          |          |
|               |          |          |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": “https://open.weixin.qq.com/connect/oauth2/authorize?appid=ww4862e4c6416306be&redirect_uri=http%3A%2F%2Foffice.teemlink.com%3A65533%2Fobpm999%2Fportal%2Fphone%2Fmain.jsp%3Fapplication%3DHdPeBqYwJyFyjHkhZu3%26action%3Dnull%26returnUrl%3D&response_type=code&scope=snsapi_base&agentid=1000009&state=3CffNlgt9B9StIjIUPB#wechat_redirect"
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 跳转链接               |

### 



### 7.8保存微信应用AgentId

**请求方式：** PUT

**请求地址 :******** /api/authtime/domain/{domainid}/application/{applicationid}/updateWeixinAgentId?id={id}

**参数说明：**

| **参数**      | **必须** | **说明**    |
| ------------- | -------- | ----------- |
| domainid      | 是       | 企业域id    |
| applicationid | 是       | 软件id      |
| id            | 是       | 微信AgentId |
|               |          |             |
|               |          |             |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": “保存成功"
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 保存结果                 |

### 



### 7.9保存微信应用secret

**请求方式：** PUT

**请求地址 :******** /api/authtime/domain/{domainid}/application/{applicationid}/updateWeixinSecret?secret={secret}

**参数说明：**

| **参数**      | **必须** | **说明**   |
| ------------- | -------- | ---------- |
| domainid      | 是       | 企业域id   |
| applicationid | 是       | 软件id     |
| secret        | 是       | 微信secret |
|               |          |            |
|               |          |            |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": “保存成功"
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 保存结果                 |

### 





## 8.钉钉配置

### 8.1获取钉钉配置

**请求方式：** GET  
**请求地址：** /api/authtime/domain/{domainid}/dingding

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid | 是       | 企业域id |

**权限说明：**

无。

**返回结果：**

```

```

**参数说明：**

| **参数**                  | **说明**                 |
| ------------------------- | ------------------------ |
| errcode                   | 返回码（0=成功，1=失败） |
| errmsg                    | 对返回码的文本描述内容   |
| data                      | 钉钉配置                 |
| data[0].id                | 企业域id                 |
| data[0].name              | 企业域名称               |
| data[0].dingdingAgentId   | 钉钉应用AgentId          |
| data[0].dingdingAppSecret | 钉钉应用Secret           |
| data[0].dingdingAppkey    | 钉钉应用key              |
| data[0].description       | 企业域描述               |

### 8.2保存钉钉配置

**请求方式：** PUT
**请求地址：** /api/authtime/domain/{domainid}/dingding

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid | 是       | 企业域id |

**请求包体**：

```
{

    "dingdingProxyType": "钉钉代理方式",

     "dingdingCorpID": "钉钉企业号id",
     
     "dingdingAppSecret": "钉钉应用的凭证密钥",
     
     "dingdingAppKey": "钉钉应用的key",
     
     "dingdingServerHost": "服务器域名(公网域名)"
     
     
     "dingdingQrCodeAppId": "钉钉扫码appid",
     "dingdingQrCodeAppSecret": "钉钉扫码appSecret",
     "dingdingQrCodeCallbackUrl": "钉钉扫码重定向地址"

}
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "保存成功"
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 结果                     |

### 8.3钉钉外网访问地址验证

**请求方式：** GET  

**请求地址：** /api/authtime/domain/{domainid}/dingding/appkey/{appkey}/appsecret/{appsecret}

**参数说明：**

| **参数**  | **必须** | **说明**       |
| --------- | -------- | -------------- |
| appkey    | 是       | 钉钉应用的key  |
| appsecret | 是       | 钉钉应用Secret |
| domainid  | 是       | 企业域id       |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "验证成功"
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 结果                     |

### 8.4同步企业域组织架构到钉钉

**请求方式：** PUT
**请求地址：** /api/authtime/domain/{domainid}/synch2dingding

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid | 是       | 企业域id |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "USER_ADD_SUCCESS": 131,
        "DEPT_ADD_SUCCESS": 60,
        "USER_ADD_FAIL": 60,
        "DEPT_ADD_FAIL": 0,
        "ERRORS": [
            {
                "NAME": "哈登",
                "ERROR": "请校验用户账号、电话、邮箱等数据的规范性",
                "TIP": "missing mobile or email, hint: [1571626602_56_f9b6a4fef27feef3588f7b530c69c14f], from ip: 113.68.195.10, more info at https://open.work.weixin.qq.com/devtool/query?e=60129 user:哈登"
            }]
            }
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 结果                     |

### 8.5同步钉钉组织架构到企业域

**请求方式：** PUT
**请求地址：** /api/authtime/domain/{domainid}/synchfromdingding

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid | 是       | 企业域id |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "USER_ADD_SUCCESS": 131,
        "DEPT_ADD_SUCCESS": 60,
        "USER_ADD_FAIL": 60,
        "DEPT_ADD_FAIL": 0,
        "ERRORS": [
            {
                "NAME": "哈登",
                "ERROR": "请校验用户账号、电话、邮箱等数据的规范性",
                "TIP": "missing mobile or email, hint: [1571626602_56_f9b6a4fef27feef3588f7b530c69c14f], from ip: 113.68.195.10, more info at https://open.work.weixin.qq.com/devtool/query?e=60129 user:哈登"
            }]
            }
}


```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 结果                     |

### 8.6生成跳转链接

**请求方式：** GET  

**请求地址 :********/domain/{domainid}/application/{applicationid}/getdingdingurl

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| domainid      | 是       | 企业域id |
| applicationid | 是       | 软件id   |
|               |          |          |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": “"
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 跳转链接                 |

### 8.7更新钉钉应用AgentId

**请求方式：** PUT

**请求地址 :******** /api/authtime/domain/{domainid}/application/{applicationid}/updatedingdingagentid?id={id}

**参数说明：**

| **参数**      | **必须** | **说明**    |
| ------------- | -------- | ----------- |
| domainid      | 是       | 企业域id    |
| applicationid | 是       | 软件id      |
| id            | 是       | 钉钉AgentId |
|               |          |             |
|               |          |             |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": “保存成功"
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 保存结果                 |

### 8.8更新钉钉应用appSecret

**请求方式：** PUT

**请求地址 :******** /api/authtime/domain/{domainid}/application/{applicationid}/updatedingdingappsecret?appsecret={secret}

**参数说明：**

| **参数**      | **必须** | **说明**       |
| ------------- | -------- | -------------- |
| domainid      | 是       | 企业域id       |
| applicationid | 是       | 软件id         |
| appsecret     | 是       | 钉钉应用secret |
|               |          |                |
|               |          |                |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": “保存成功"
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 保存结果                 |

### 8.9更新钉钉应用appKey

**请求方式：** PUT

**请求地址 :******** /api/authtime/domain/{domainid}/application/{applicationid}/updatedingdingappkey?appkey={appkey}

**参数说明：**

| **参数**      | **必须** | **说明**   |
| ------------- | -------- | ---------- |
| domainid      | 是       | 企业域id   |
| applicationid | 是       | 软件id     |
| appkey        | 是       | 钉钉appkey |
|               |          |            |
|               |          |            |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": “保存成功"
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 保存结果                 |

## 9.  **管理员**

### 9.1获取管理员列表

**请求方式：** POST  
**请求地址：** /api/authtime/domain/{domainid}/admins?currpage={currpage}&
pagelines={pagelines}

**参数说明：**

| **参数** | **必须** | **说明**   |
| -------- | -------- | ---------- |
| domainid | 是       | 企业域id   |
| name     | 否       | 管理员名称 |

**请求包体：**

{
  	"name": "管理员名称"

}

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "defaultDepartment": "n5bdXBZn4Nqt3nyUGyb",
            "domainUser": "true",
            "name": "junye",
            "id": "0TblO2uKjQ2sLDY64yF",
            "loginno": "junye",
            "email": ""
        },
        {
            "defaultDepartment": "Z42xU8LmniRouZ93E7s",
            "domainUser": "true",
            "name": "janjan",
            "id": "0URvyCUds2T4PGx4yLB",
            "loginno": "janceshi",
            "email": "775377369@qq.com"
        },
        {
            "defaultDepartment": "Z42xU8LmniRouZ93E7s",
            "domainUser": "true",
            "name": "liang",
            "id": "22TY7eJ46UvOUmmXJbc",
            "loginno": "liang",
            "email": "1123213243fdfdfdgfd@qq.com"
        },
        {
            "defaultDepartment": "Z42xU8LmniRouZ93E7s",
            "domainUser": "true",
            "name": "sam_hr",
            "id": "2TE7lzsbdyqLhndabbN",
            "loginno": "sam_hr",
            "email": "hr_sam@163.com"
        }
    ]
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 管理员列表             |
| data[0].id   | 管理员id                 |
| data[0].name | 管理员名称               |
| data[0].domainUser   | 是否是管理员                 |
| data[0].loginno | 管理员用户名               |
| data[0].email | 管理员email               |

### 9.2添加管理员

**请求方式：** PUT  
**请求地址：** /api/authtime/domain/{domainid}/admin

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid  | 是   |     企业域id     |

**请求包体**：

```
[
    "管理员id",
    "ID2",
    "ID3"
]
```



**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "添加成功"
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 结果               |


### 9.3移除管理员

**请求方式：** DELETE
**请求地址：**  /api/authtime/domain/{domainid}/admin

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid     |是   |     企业域id     |

**请求包体**：

```
[
    "管理员000
    "ID2",
    "ID3"
]
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "移除成功"
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 结果               |

### 9.1获取不是管理员的用户列表

**请求方式：** POST  
**请求地址：** /api/authtime/domain/{domainid}/notadmins?currpage={currpage}&
pagelines={pagelines}

**参数说明：**

| **参数** | **必须** | **说明**   |
| -------- | -------- | ---------- |
| domainid | 是       | 企业域id   |
| name     | 否       | 管理员名称 |

**请求包体：**

{
  	"name": "管理员名称"

}

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "defaultDepartment": "n5bdXBZn4Nqt3nyUGyb",
            "domainUser": "true",
            "name": "junye",
            "id": "0TblO2uKjQ2sLDY64yF",
            "loginno": "junye",
            "email": ""
        },
        {
            "defaultDepartment": "Z42xU8LmniRouZ93E7s",
            "domainUser": "true",
            "name": "janjan",
            "id": "0URvyCUds2T4PGx4yLB",
            "loginno": "janceshi",
            "email": "775377369@qq.com"
        },
        {
            "defaultDepartment": "Z42xU8LmniRouZ93E7s",
            "domainUser": "true",
            "name": "liang",
            "id": "22TY7eJ46UvOUmmXJbc",
            "loginno": "liang",
            "email": "1123213243fdfdfdgfd@qq.com"
        },
        {
            "defaultDepartment": "Z42xU8LmniRouZ93E7s",
            "domainUser": "true",
            "name": "sam_hr",
            "id": "2TE7lzsbdyqLhndabbN",
            "loginno": "sam_hr",
            "email": "hr_sam@163.com"
        }
    ]
}

```

**参数说明：**

| **参数**           | **说明**                 |
| ------------------ | ------------------------ |
| errcode            | 返回码（0=成功，1=失败） |
| errmsg             | 对返回码的文本描述内容   |
| data               | 管理员列表               |
| data[0].id         | 管理员id                 |
| data[0].name       | 管理员名称               |
| data[0].domainUser | 是否是管理员             |
| data[0].loginno    | 管理员用户名             |
| data[0].email      | 管理员email              |



## 10.  **工作日历**

### 10.1查询工作日历列表

**请求方式：** POST  
**请求地址：** /api/authtime/domain/{domainid}/calendars?currpage={currpage}&
pagelines={pagelines}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid | 是       | 企业域id |
| name     | 是       | 日历名称 |

**请求包体：**

{
  	"name": "日历名称"

}

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "linesPerPage": 10,
        "pageCount": 1,
        "datas": [
            {
                "specialDays": [],
                "remark": "24小时制工作日历。",
                "workingTime": 24,
                "type": "Eight_TimeZone",
                "lazyLoad": true,
                "version": 0,
                "domainid": "3CffNlgt9B9StIjIUPB",
                "standardDays": [],
                "sortId": "154561417645400000",
                "name": "24小时日历",
                "id": "HmKdJTD3m76sGFo45Ob",
                "applicationid": null,
                "lastModifyDate": "2018-12-24T01:16:16.000+0000"
            },
            {
                "specialDays": [],
                "remark": "core.workcalendar.night.calendarinfo",
                "workingTime": 8,
                "type": "Eight_TimeZone",
                "lazyLoad": true,
                "version": 0,
                "domainid": "3CffNlgt9B9StIjIUPB",
                "standardDays": [],
                "sortId": "154339251609900000",
                "name": "夜班日历",
                "id": "i7xj207zBMEwBp8aATE",
                "applicationid": null,
                "lastModifyDate": "2018-11-28T08:08:36.000+0000"
            },
            {
                "specialDays": [],
                "remark": "core.workcalendar.standard.calendarinfo",
                "workingTime": 8,
                "type": "Eight_TimeZone",
                "lazyLoad": true,
                "version": 0,
                "domainid": "3CffNlgt9B9StIjIUPB",
                "standardDays": [],
                "sortId": "154339251598300000",
                "name": "标准日历",
                "id": "ZKsRAyDrAP7u0NKPQdR",
                "applicationid": null,
                "lastModifyDate": "2018-11-28T08:08:36.000+0000"
            },
            {
                "specialDays": [],
                "remark": "1",
                "workingTime": 8,
                "type": "Eight_TimeZone",
                "lazyLoad": true,
                "version": 0,
                "domainid": "3CffNlgt9B9StIjIUPB",
                "standardDays": [],
                "sortId": "156948415847000000",
                "name": "1",
                "id": "__JiZSFqbBRZUn7Rna5HR",
                "applicationid": null,
                "lastModifyDate": "2019-09-26T07:49:18.000+0000"
            }
        ],
        "pageNo": 1,
        "rowCount": 4
    }
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 工作日历列表               |
| data[0].remark   | 工作日历描述                 |
| data[0].workingTime | 工作时间               |
| data[0].name   | 工作日历名称                 |
| data[0].id | 工作日历id               |
| data[0].remark   | 描述                 |
| data[0].lastModifyDate | 最后修改时间               |



### 10.2新建工作日历

**请求方式：** POST  
**请求地址：** /api/authtime/domain/{domainid}/calendar

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid    | 是   |     企业域id     |

**请求包体**：

```
{

    "_calendarid": "工作日历id",

    "name": "工作日历名称",

    "remark": "描述"

}
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "保存成功"
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 保存结果              |


### 10.3更新工作日历

**请求方式：** PUT  
**请求地址：** /api/authtime/domain/{domainid}/calendar/{id}

**参数说明：**

| **参数** | **必须** | **说明**   |
| -------- | -------- | ---------- |
| domainid | 是       | 企业域id   |
| id       | 是       | 工作日历id |

**请求包体**：

```
{

    "_calendarid": "工作日历id",

    "name": "工作日历名称",

    "remark": "描述"

}
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "保存成功"
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 保存结果              |

### 10.4删除工作日历

**请求方式：** DELETE  
**请求地址：** /api/authtime/calendar

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
|      |    |          |

**请求包体**：

```
[
    "工作日历id",
    "ID2",
    "ID3"
]
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "删除成功"
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 删除结果              |

### 10.5  编辑日历

**请求方式：** GET
**请求地址：** /api/authtime/domain/{domainid}/getworkcalendars

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid | 是       | 企业域id |
|          |          |          |

**请求包体**：

```
{

    "_calendarid": "工作日历id",

    "name": "工作日历名称",

    "remark": "描述"

}
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "__M7m6kH3I9Du1dU1MVKj": "333",
        "__Q0UMGoHcaJLG1AdnOap": "1212211212",
        "ZKsRAyDrAP7u0NKPQdR": "标准日历",
        "__TCYQCu0dZrYlmcA4W0M": "1ed1",
        "__fQMBT4feHNX8dOrplcr": "121212",
        "HmKdJTD3m76sGFo45Ob": "我的9",
        "i7xj207zBMEwBp8aATE": "夜班日历",
        "__akCNI7UlCr5N06stJjI": "24小时日历",
        "__JiZSFqbBRZUn7Rna5HR": "1",
        "__PpXMzJRQ393iGM7hsHx": "24小时日历1"
    }
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     |                          |



|      |      |
| ---- | ---- |
|      |      |
|      |      |

### 10.6获取工作周列表

**请求方式：** GET
**请求地址：** /api/authtime/domain/{domainid}/calendar/{id}/getstandardday

**参数说明：**

| **参数** | **必须** | **说明**   |
| -------- | -------- | ---------- |
| domainid | 是       | 企业域id   |
| id       | 是       | 工作日历id |

**请求包体**：

```

```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 7,
        "linesPerPage": 7,
        "pageNo": 1,
        "datas": [
            {
                "id": "SD88Fkeex5nuP263SN7",
                "WORKING_DAY": "01",
                "NOT_WORKING_DAY": "02",
                "remark": null,
                "calendar": {
                    "id": "ZKsRAyDrAP7u0NKPQdR",
                    "type": "Eight_TimeZone",
                    "name": "标准日历",
                    "remark": "core.workcalendar.standard.calendarinfo",
                    "lastModifyDate": "2018-11-28T08:08:36.000+0000",
                    "standardDays": [],
                    "specialDays": [],
                    "workingTime": 8
                },
                "workingDayStatus": "01",
                "weekDays": 3,
                "cssClass": "Wday",
                "spc": 1,
                "lastModifyDate": "2018-11-28T08:08:36.000+0000",
                "startTime1": "08:30",
                "startTime2": "14:00",
                "startTime3": "",
                "startTime4": "",
                "startTime5": "",
                "endTime1": "12:30",
                "endTime2": "18:00",
                "endTime3": "",
                "endTime4": "",
                "endTime5": "",
                "dayIndex": 0,
                "border": false,
                "workingDay": true
            },
            {
                "id": "X5KgmfQ5t6MMchzgcFo",
                "WORKING_DAY": "01",
                "NOT_WORKING_DAY": "02",
                "remark": null,
                "calendar": {
                    "id": "ZKsRAyDrAP7u0NKPQdR",
                    "type": "Eight_TimeZone",
                    "name": "标准日历",
                    "remark": "core.workcalendar.standard.calendarinfo",
                    "lastModifyDate": "2018-11-28T08:08:36.000+0000",
                    "standardDays": [],
                    "specialDays": [],
                    "workingTime": 8
                },
                "workingDayStatus": "01",
                "weekDays": 2,
                "cssClass": "Wday",
                "spc": 1,
                "lastModifyDate": "2018-11-28T08:08:36.000+0000",
                "startTime1": "08:30",
                "startTime2": "14:00",
                "startTime3": "",
                "startTime4": "",
                "startTime5": "",
                "endTime1": "12:30",
                "endTime2": "18:00",
                "endTime3": "",
                "endTime4": "",
                "endTime5": "",
                "dayIndex": 0,
                "border": false,
                "workingDay": true
            },
            {
                "id": "VxafoVfOoTASDJTsArd",
                "WORKING_DAY": "01",
                "NOT_WORKING_DAY": "02",
                "remark": null,
                "calendar": {
                    "id": "ZKsRAyDrAP7u0NKPQdR",
                    "type": "Eight_TimeZone",
                    "name": "标准日历",
                    "remark": "core.workcalendar.standard.calendarinfo",
                    "lastModifyDate": "2018-11-28T08:08:36.000+0000",
                    "standardDays": [],
                    "specialDays": [],
                    "workingTime": 8
                },
                "workingDayStatus": "01",
                "weekDays": 1,
                "cssClass": "Wday",
                "spc": 1,
                "lastModifyDate": "2018-11-28T08:08:36.000+0000",
                "startTime1": "08:30",
                "startTime2": "14:00",
                "startTime3": "",
                "startTime4": "",
                "startTime5": "",
                "endTime1": "12:30",
                "endTime2": "18:00",
                "endTime3": "",
                "endTime4": "",
                "endTime5": "",
                "dayIndex": 0,
                "border": false,
                "workingDay": true
            },
            {
                "id": "PQsrDjfScwaVmn3s8Fn",
                "WORKING_DAY": "01",
                "NOT_WORKING_DAY": "02",
                "remark": null,
                "calendar": {
                    "id": "ZKsRAyDrAP7u0NKPQdR",
                    "type": "Eight_TimeZone",
                    "name": "标准日历",
                    "remark": "core.workcalendar.standard.calendarinfo",
                    "lastModifyDate": "2018-11-28T08:08:36.000+0000",
                    "standardDays": [],
                    "specialDays": [],
                    "workingTime": 8
                },
                "workingDayStatus": "02",
                "weekDays": 0,
                "cssClass": "Wwday",
                "spc": 0,
                "lastModifyDate": "2018-11-28T08:08:36.000+0000",
                "startTime1": "",
                "startTime2": "",
                "startTime3": "",
                "startTime4": "",
                "startTime5": "",
                "endTime1": "",
                "endTime2": "",
                "endTime3": "",
                "endTime4": "",
                "endTime5": "",
                "dayIndex": 0,
                "border": false,
                "workingDay": false
            }
        ],
        "pageCount": 1
    }
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |



### 10.7保存工作周

**请求方式：** PUT
**请求地址：**/api/authtime/domain/{domainid}/calendar/{id}/savestandardday

**参数说明：**

| **参数** | **必须** | **说明**   |
| -------- | -------- | ---------- |
| domainid | 是       | 企业域id   |
| id       | 是       | 工作日历id |

**请求包体**：

```
{
    "id": "standardday的id",
    
    "weekDay": "周" int类型（1234567对应周一到周日）,

    "strstatus": "01（01为工作日,02为非）",

    "startTime1": "12：00"，
    
    "endTime1": ""，
    
    "startTime2": ""，
    
    "endTime2": ""，
    
    "startTime3": ""，
    
    "endTime3": ""，
    
    "startTime4": ""，
    
    "endTime4": ""，
    
    "startTime5": ""，
    
    "endTime5": ""，
    
    "remark": "描述"

}
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "保存成功"
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |

### 10.8获取例外日列表

**请求方式：** GET
**请求地址：**  /api/authtime/domain/{domainid}/calendar/{id}/getspecialday?currpage={currpage}&
pagelines={pagelines}

**参数说明：

**参数说明：**

| **参数** | **必须** | **说明**   |
| -------- | -------- | ---------- |
| domainid | 是       | 企业域id   |
| id       | 是       | 工作日历id |

**请求包体**：

```
{

    "_calendarid": "工作日历id",

    "name": "工作日历名称",

    "remark": "描述"

}
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 2,
        "linesPerPage": 10,
        "pageNo": 1,
        "datas": [
            {
                "id": "__lRdZfSVhf3OjQyg46pJ",
                "WORKING_DAY": "01",
                "NOT_WORKING_DAY": "02",
                "remark": "描述1111",
                "calendar": {
                    "id": "ZKsRAyDrAP7u0NKPQdR",
                    "type": "Eight_TimeZone",
                    "name": "标准日历",
                    "remark": "core.workcalendar.standard.calendarinfo",
                    "lastModifyDate": "2018-11-28T08:08:36.000+0000",
                    "standardDays": [],
                    "specialDays": [],
                    "workingTime": 8
                },
                "workingDayStatus": "02",
                "weekDays": 0,
                "cssClass": "Wwday",
                "spc": 0,
                "lastModifyDate": "2019-10-30T06:38:32.000+0000",
                "startTime1": "",
                "startTime2": "",
                "startTime3": "",
                "startTime4": "",
                "startTime5": "",
                "endTime1": "",
                "endTime2": "",
                "endTime3": "",
                "endTime4": "",
                "endTime5": "",
                "dayIndex": 0,
                "startDate": "2019-10-22T13:00:00.000+0000",
                "endDate": "2019-11-11T13:00:00.000+0000",
                "border": false,
                "workingDay": false
            },
            {
                "id": "__UYBC1cRSuVdJGixu7Qa",
                "WORKING_DAY": "01",
                "NOT_WORKING_DAY": "02",
                "remark": "描述",
                "calendar": {
                    "id": "ZKsRAyDrAP7u0NKPQdR",
                    "type": "Eight_TimeZone",
                    "name": "标准日历",
                    "remark": "core.workcalendar.standard.calendarinfo",
                    "lastModifyDate": "2018-11-28T08:08:36.000+0000",
                    "standardDays": [],
                    "specialDays": [],
                    "workingTime": 8
                },
                "workingDayStatus": "02",
                "weekDays": 0,
                "cssClass": "Wwday",
                "spc": 0,
                "lastModifyDate": null,
                "startTime1": "",
                "startTime2": "",
                "startTime3": "",
                "startTime4": "",
                "startTime5": "",
                "endTime1": "",
                "endTime2": "",
                "endTime3": "",
                "endTime4": "",
                "endTime5": "",
                "dayIndex": 0,
                "startDate": "2019-10-22T13:00:00.000+0000",
                "endDate": "2019-11-11T13:00:00.000+0000",
                "border": false,
                "workingDay": false
            }
        ],
        "pageCount": 1
    }
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |

### 10.9保存例外日

**请求方式：** PUT

**请求地址：** /api/authtime/domain/{domainid}//calendar/{id}/savespecialday

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid | 是       | 企业域id |
|          |          |          |

**请求包体**：

```
{
    "id": "例外日id",

    "strstatus": "01（01为工作日,02为非）",

    "startTime1": "12：00"，
    
    "endTime1": ""，
    
    "startTime2": ""，
    
    "endTime2": ""，
    
    "startTime3": ""，
    
    "endTime3": ""，
    
    "startTime4": ""，
    
    "endTime4": ""，
    
    "startTime5": ""，
    
    "endTime5": ""，
    
    "remark": "描述"，
    
    "startDate": "开始日期 yyyy-MM-dd HH:mm:ss"，
    
    "endDate": "结束日期 yyyy-MM-dd HH:mm:ss"，

}
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "保存成功"
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |



```

```

### 10.10新建例外日

**请求方式：** POST
**请求地址：** /api/authtime/domain/{domainid}//calendar/{id}/addspecialday

**参数说明：**

| **参数** | **必须** | **说明**   |
| -------- | -------- | ---------- |
| domainid | 是       | 企业域id   |
| id       | 是       | 工作日历id |

**请求包体**：

```
{

    "strstatus": "01（01为工作日,02为非）",

    "startTime1": "12：00"，
    
    "endTime1": ""，
    
    "startTime2": ""，
    
    "endTime2": ""，
    
    "startTime3": ""，
    
    "endTime3": ""，
    
    "startTime4": ""，
    
    "endTime4": ""，
    
    "startTime5": ""，
    
    "endTime5": ""，
    
    "remark": "描述"，
    
    "startDate": "开始日期 yyyy-MM-dd HH:mm:ss"，
    
    "endDate": "结束日期 yyyy-MM-dd HH:mm:ss"，

}
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "保存成功"
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |

### 10.11删除例外日

**请求方式：** DELETE
**请求地址：** /api/authtime/domain/calendar/deletespecialday

**参数说明：**

| **参数** | **必须** | **说明**   |
| -------- | -------- | ---------- |
| domainid | 是       | 企业域id   |
| id       | 是       | 工作日历id |

**请求包体**：

```
[
    "ID1",
    "ID2",
    "ID3"
]
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "保存成功"
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |

## 11.  **字段扩展管理**

### 11.1查询扩展字段列表

**请求方式：** POST  
**请求地址：** /api/authtime/domain/{domainid}/fieldextends?currpage={currpage}&
pagelines={pagelines}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid | 是       | 企业域id |
| type     | 是       | 字段类型 |
| fortable | 是       | 所属模块 |
|          |          |          |
**请求包体：**

{
	"type": "字段类型",

​	"fortable": "所属模块"

}

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "linesPerPage": 10,
        "pageCount": 1,
        "datas": [
            {
                "fid": "4028d0816d60f933016d61c92d060003",
                "enabel": true,
                "forTable": "tableUser",
                "sortNumber": 21,
                "label": "aaa",
                "type": "string",
                "lazyLoad": true,
                "version": 0,
                "domainid": "3CffNlgt9B9StIjIUPB",
                "sortId": null,
                "isNull": null,
                "name": "field5",
                "id": null,
                "applicationid": null
            },
            {
                "fid": "4028d0816d6cecfd016d6cf65d8c0000",
                "enabel": true,
                "forTable": "tableUser",
                "sortNumber": 123123,
                "label": "123123",
                "type": "string",
                "lazyLoad": true,
                "version": 0,
                "domainid": "3CffNlgt9B9StIjIUPB",
                "sortId": null,
                "isNull": null,
                "name": "field2",
                "id": null,
                "applicationid": null
            },
            {
                "fid": "4028d0816d6d7bc0016d6d7be6680000",
                "enabel": true,
                "forTable": "tableUser",
                "sortNumber": null,
                "label": "999",
                "type": null,
                "lazyLoad": true,
                "version": 0,
                "domainid": "3CffNlgt9B9StIjIUPB",
                "sortId": null,
                "isNull": null,
                "name": "field2",
                "id": null,
                "applicationid": null
            },
        "pageNo": 1,
        "rowCount": 10
    }
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 扩展字段列表              |
| data[0].fid   | 扩展字段id                 |
| data[0].enabel | 是否显示在列表中               |
| data[0].forTable   | 字段所属表                 |
| data[0].sortNumber | 排序位置优先级，数据越小，排序越前               |
| data[0].label   | 字段标签                 |
| data[0].type | 字段类型               |
| data[0].fid   | 企业域id                 |
| data[0].isNull | 是否可以为空               |
| data[0].name | 字段名字               |


### 11.2新建扩展字段

**请求方式：** POST
**请求地址：** /api/authtime/domain/{domainid}/fieldextend

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid     | 是   |     企业域id     |

**请求包体**：

```
{
    "label": "字段标签",

    "respectiveField": "字段名字",

    "sortNumber": "排序位置优先级，数据越小，排序越前 ",

    "type": "字段类型",

    "enabel": "是否显示在列表中",

    "forTable": "字段所属表"
}
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "保存成功"
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 保存结果               |

### 11.3更新扩展字段

**请求方式：** PUT
**请求地址：** /api/authtime/domain/{domainid}/fieldextend/{id}

**参数说明：**

| **参数** | **必须** | **说明**   |
| -------- | -------- | ---------- |
| domainid | 是       | 企业域id   |
| id       | 是       | 扩展字段id |
|          |          |            |

**请求包体**：

```
{
    "label": "字段标签",

    "respectiveField": "字段名字",

    "sortNumber": "排序位置优先级，数据越小，排序越前 ",

    "type": "字段类型",

    "enabel": "是否显示在列表中",

    "forTable": "字段所属表"
}
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "保存成功"
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 保存结果               |

### 11.4删除扩展字段

**请求方式：** DELETE
**请求地址：** /api/authtime/domain/{domainid}/fieldextend

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid | 是 | 企业域id |

**请求包体**：

```
[
    "字段名、ID、所属模块合成的串集合，格式为ID-NAME-FORTABLE",
    "ID-NAME-FORTABLE",
    "ID-NAME-FORTABLE"
]
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "删除成功"
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 删除结果               |



### 11.5获取未使用字段

**请求方式：** GET
**请求地址：** /api/authtime/domain/{domainid}/getunusefields?type={type}

**参数说明：**

| **参数** | **必须** | **说明** |      |      |      |
| -------- | -------- | -------- | ---- | ---- | ---- |
| domainid | 是       | 企业域id |      |      |      |
| type | 是       | user为用户，dept为部门 |      |      |      |

**请求包体**：

```

```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        "field2",
        "field3",
        "field4",
        "field5",
        "field6",
        "field7",
        "field8",
        "field9",
        "field10"
    ]
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     |                          |



## 12.  **操作日记**

### 12.1查询操作日记列表

**请求方式：** POST 
**请求方式：**/api/authtime/domain/{domainid}/loggers?currpage={currpage}&
pagelines={pagelines}

**参数说明：**

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| operator | 否       | 操作人   |
| ip       | 否       | ip地址   |
| date     | 否       | 操作日期 |
| domainid | 是       | 企业域id |

**请求包体：**

{
	"operator": "操作人"，

​	"ip": "  ip地址"，

​	"date": "操作日期"

}

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 1702,
        "linesPerPage": 10,
        "pageNo": 1,
        "datas": [
            {
                "id": "2HoV1AwYZn2HmwROgfW",
                "user": null,
                "date": "2019-07-23T06:45:11.000+0000",
                "type": "流程处理",
                "description": "{*[Form]*}-主流程",
                "operator": "admin",
                "ip": "0:0:0:0:0:0:0:1"
            },
            {
                "id": "SolCsNLgDVbjYiQp4zM",
                "user": null,
                "date": "2019-07-23T06:44:20.000+0000",
                "type": "{*[Login]*}",
                "description": "{*[Login]*}{*[System]*}",
                "operator": "sam",
                "ip": "0:0:0:0:0:0:0:1"
            },
            {
                "id": "vT0SGqCn2UwMa2rBSCV",
                "user": null,
                "date": "2019-07-23T06:39:23.000+0000",
                "type": "{*[Login]*}",
                "description": "{*[Login]*}{*[System]*}",
                "operator": "sam_test",
                "ip": "0:0:0:0:0:0:0:1"
            }
        ],
        "pageCount": 171
    }
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 操作日记列表               |
| data[0].id   | 操作日记id                 |
| data[0].date | 日期               |
| data[0].type | 操作类型                         |
| data[0].description|       操作描述                   |
|  data[0].operator  |    操作人                      |
|      data[0].operator  |  操作ip                        |

### 12.2更新操作日记是否记录

**请求方式：** PUT
**请求地址：**/api/authtime/domain/{domainid}/logger

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid    | 是   |     企业域id     |

**请求包体**：

```
{
    "isLog": "是否记录（true=是，false=否）"
}
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "保存成功"
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 保存结果              |

### 12.3删除操作记录

**请求方式：** DELETE
**请求地址：**/api/authtime/domain/{domainid}/loggers

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid | 是   |     企业域id     |

**请求包体**：

```
[
    "操作记录ID1",
    "操作记录ID2",
    "操作记录ID3"
]
```


**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "删除成功"
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 删除结果               |

### 12.4查询操作日记是否记录

**请求方式：** GET
**请求地址：**/api/authtime/domain/{domainid}/logger

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid | 是       | 企业域id |

**请求包体**：

```

```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {"isLog": "是否记录（true=是，false=否）"}
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 保存结果                 |

## 13.  **流程监控**

### 13.1查询流程监控列表

**请求方式：** POST  
**请求地址：** /api/authtime/domain/{domainid}/workflow/flowstaterts?currpage={currpage}&
pagelines={pagelines}

**参数说明：**

| **参数**         | **必须** | **说明**     |
| ---------------- | -------- | ------------ |
| domainid         | 是       | 企业域id     |
| applicationid    | 是       | 软件id       |
| flowname         | 否       | 流程名称     |
| statelabel       | 否       | 当前节点     |
| firstprocesstime | 否       | 开始时间     |
| lastprocesstime  | 否       | 最后处理时间 |
| lastauditor      | 否       | 最后处理人   |
| summary          | 否       | 摘要         |
| initiator        | 否       | 发起人       |

**请求包体：**

{
	"application": "软件id"，

​	"_flowName": "流程名称"，

​	"_stateLabel": "当前节点"

​	"_initiator": "发起人",

​	"_firstProcessTime": "开始时间",

​	"_lastProcessTime": "最后处理时间",

​	"_lastAuditor": "最后处理人",

​	"_summary": "摘要"

}

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "rowCount": 1,
        "linesPerPage": 10,
        "pageNo": 1,
        "datas": [
            {
                "id": "__TS501IzlxYVliUmQJI1",
                "summary": "",
                "flowName": "请假单_自由流程",
                "stateLabel": "管理员",
                "initiator": "test",
                "initiatorId": "RBAXZyYufKGxTceUYFT",
                "initiatorDept": "我的公司",
                "initiatorDeptId": "FadYTdDJAP7XEA7OM9m",
                "lastAuditor": "test",
                "firstProcessTime": "2019-10-08",
                "lastProcessTime": "2019-10-08",
                "flowstatertId": "__CIpjyzYktLoSIwuMc9y",
                "flowId": null,
                "formId": "OGMmff1QTZYqFk5vfeD",
                "docId": "__TS501IzlxYVliUmQJI1",
                "status": "pending",
                "auditorNames": "管理员",
                "auditorList": "[{\"instanceId\":\"__CIpjyzYktLoSIwuMc9y\",\"flowName\":\"请假单_自由流程\",\"nodes\":[{\"nodeId\":\"YpfsRofkksTJlMBoOgD\",\"stateLabel\":\"管理员\",\"state\":0,\"auditors\":[{\"id\":\"YpfsRofkksTJlMBoOgD\",\"name\":\"管理员\",\"userCode\":\"11111caosinimabi\"}],\"coAuditors\":[]}]}]",
                "coAuditorList": null,
                "lastFlowOperation": "1",
                "flowIndex": ""
            }
        ],
        "pageCount": 1
    }
}

```

**参数说明：**

| **参数**            | **说明**                 |
| ------------------- | ------------------------ |
| errcode             | 返回码（0=成功，1=失败） |
| errmsg              | 对返回码的文本描述内容   |
| data                | 流程监控列表             |
| data[0].id          | 流程id                   |
| data[0].summary     | 摘要                     |
| data[0].flowName    | 流程名称                 |
| data[0].stateLabel  | 流程状态                 |
| data[0].initiator   | 发起人名字               |
| data[0].initiatorId | 发起人Id                 |
| data[0].initiatorDept | 发起人部门                |
| data[0].initiatorDeptId | 发起人部门Id                 |
| data[0].lastAuditor | 最后处理人名字                 |
| data[0].firstProcessTime          | 流程开始时间                   |
| data[0].lastProcessTime     | 最后处理时间                     |
| data[0].flowstatertId    | 流程实例id                 |
| data[0].flowId  | 流程模板id                 |
| data[0].formId   | 表单id               |
| data[0].docId |    文档id             |
| data[0].status | 状态                |
| data[0].auditorNames | 当前审核人名称(以分","号隔开)                 |
| data[0].auditorList | 当前审批人列表（JSON格式描述）                 |
| data[0].coAuditorList |    当前协办人列表（JSON格式描述）             |
| data[0].lastFlowOperation | 最后一次流程处理的代码                |
| data[0].flowIndex | 流程索引                |



### 13.2删除流程实例

**请求方式：** DELETE
**请求地址：**/api/authtime/domain/applicationid/{applicationid}/workflow/flowstaterts

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationid | 是       | 软件id   |

**请求包体**：

```
[
    "流程ID1",
    "流程ID2",
    "流程ID3"
]
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "删除成功"
}

```

**参数说明：**

| **参数**     | **说明**                 |
| ------------ | ------------------------ |
| errcode      | 返回码（0=成功，1=失败） |
| errmsg       | 对返回码的文本描述内容   |
| data         | 删除结果              |

### 13.3流程节点耗时

**请求方式：** GET
**请求地址：**/api/authtime/domain/{domainid}/applicationid/{applicationid}/workflow/flowAndNodeTimeConsuming?daterange={daterange}&showmode={showmode}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationid | 是       | 软件id   |
| domainid | 是       | 企业域id   |
| showmode | 是       | 显示所有用户（all）    |
| daterange | 是       | 日期（今天-today 本周 thisweek 本月-thismonth 本年=thisyear）|

**请求包体**：



**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": null,
            "resultFields": [
                {
                    "fieldName": "AMOUNT",
                    "value": 0.0
                }
            ],
            "groupColumns": [
                {
                    "columnName": "FLOWID",
                    "value": "0BwBF4EdlH6xpAbSoZV"
                },
                {
                    "columnName": "FLOWNAME",
                    "value": "组织范围"
                },
                {
                    "columnName": "STARTNODENAME",
                    "value": "任意"
                }
            ]
        }]
  }

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 删除结果                 |

### 13.4流程耗时占比

**请求方式：** GET
**请求地址：**/api/authtime/domain/{domainid}/applicationid/{applicationid}/workflow/flowTimeConsumingAccounting?daterange={daterange}&showmode={showmode}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationid | 是       | 软件id   |
| domainid | 是       | 企业域id   |
| showmode | 是       | 显示所有用户（all）    |
| daterange | 是       | 日期（今天-today 本周 thisweek 本月-thismonth 本年=thisyear）|

**请求包体**：



**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": null,
            "resultFields": [
                {
                    "fieldName": "AMOUNT",
                    "value": 0.0
                }
            ],
            "groupColumns": [
                {
                    "columnName": "FLOWID",
                    "value": "0BwBF4EdlH6xpAbSoZV"
                },
                {
                    "columnName": "FLOWNAME",
                    "value": "组织范围"
                }
            ]
        }
       }

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 删除结果                 |

### 13.5流程实例占比

**请求方式：** GET
**请求地址：**/api/authtime/domain/{domainid}/applicationid/{applicationid}/workflow/flowAccounting?daterange={daterange}&showmode={showmode}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationid | 是       | 软件id   |
| domainid | 是       | 企业域id   |
| showmode | 是       | 显示所有用户（all）    |
| daterange | 是       | 日期（今天-today 本周 thisweek 本月-thismonth 本年=thisyear）|

**请求包体**：



**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": null,
            "resultFields": [
                {
                    "fieldName": "AMOUNT",
                    "value": 0.0
                }
            ],
            "groupColumns": [
                {
                    "columnName": "FLOWID",
                    "value": "0BwBF4EdlH6xpAbSoZV"
                },
                {
                    "columnName": "FLOWNAME",
                    "value": "组织范围"
                }
            ]
        }]
       }

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 删除结果                 |



|      |      |
| ---- | ---- |
|      |      |
|      |      |
|      |      |


### 13.6流程耗时排序

**请求方式：** GET
**请求地址：**/api/authtime/domain/{domainid}/applicationid/{applicationid}/workflow/doAnalyzerActorTimeConsumingTopX?daterange={daterange}&showmode={showmode}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationid | 是       | 软件id   |
| domainid | 是       | 企业域id   |
| showmode | 是       | 显示所有用户（all）    |
| daterange | 是       | 日期（今天-today 本周 thisweek 本月-thismonth 本年=thisyear）|

**请求包体**：



**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": [
        {
            "id": null,
            "resultFields": [
                {
                    "fieldName": "AMOUNT",
                    "value": 95334.0
                }
            ],
            "groupColumns": [
                {
                    "columnName": "FLOWID",
                    "value": "FPnfiZrQktvBKa5thBd"
                },
                {
                    "columnName": "FLOWNAME",
                    "value": "请假申请"
                },
                {
                    "columnName": "STARTNODENAME",
                    "value": "申请人"
                },
                {
                    "columnName": "ENDNODENAME",
                    "value": "主管"
                },
                {
                    "columnName": "AUDITOR",
                    "value": "ycRsc26GiLHzkJuinLm"
                },
                {
                    "columnName": "DOCID",
                    "value": "UKNr2QPNqT8srz5RXVj"
                }
            ]
        },
        {
            "id": null,
            "resultFields": [
                {
                    "fieldName": "AMOUNT",
                    "value": 63220.0
                }
            ],
            "groupColumns": [
                {
                    "columnName": "FLOWID",
                    "value": "VN97M5KJ3TAx7sOs4KL"
                },
                {
                    "columnName": "FLOWNAME",
                    "value": "挂起"
                },
                {
                    "columnName": "STARTNODENAME",
                    "value": "测试1"
                },
                {
                    "columnName": "ENDNODENAME",
                    "value": "测试1"
                },
                {
                    "columnName": "AUDITOR",
                    "value": "RusnXYokDS3ox4l1WDD"
                },
                {
                    "columnName": "DOCID",
                    "value": "WAA37ld1MkfL4kRh21f"
                }
            ]
        },
        {
            "id": null,
            "resultFields": [
                {
                    "fieldName": "AMOUNT",
                    "value": 4503.0
                }
            ],
            "groupColumns": [
                {
                    "columnName": "FLOWID",
                    "value": "f10LmdSPbI5LYZDoZ93"
                },
                {
                    "columnName": "FLOWNAME",
                    "value": "加签主办人"
                },
                {
                    "columnName": "STARTNODENAME",
                    "value": "申请"
                },
                {
                    "columnName": "ENDNODENAME",
                    "value": "人事审核"
                },
                {
                    "columnName": "AUDITOR",
                    "value": "sLXMZ59zCXSz3uoq9Yf"
                },
                {
                    "columnName": "DOCID",
                    "value": "puBVItjMobvwfaaz9vO"
                }
            ]
        },
        {
            "id": null,
            "resultFields": [
                {
                    "fieldName": "AMOUNT",
                    "value": 3987.0
                }
            ],
            "groupColumns": [
                {
                    "columnName": "FLOWID",
                    "value": "zyAn3KlaecPYY6zUHuh"
                },
                {
                    "columnName": "FLOWNAME",
                    "value": "带时间流程审核"
                },
                {
                    "columnName": "STARTNODENAME",
                    "value": "提交申请"
                },
                {
                    "columnName": "ENDNODENAME",
                    "value": "主管审核"
                },
                {
                    "columnName": "AUDITOR",
                    "value": "5PN80KzuWw6TEEMLINK"
                },
                {
                    "columnName": "DOCID",
                    "value": "aNWtG5Ih2Lz7fiOFwQ6"
                }
            ]
        },
        {
            "id": null,
            "resultFields": [
                {
                    "fieldName": "AMOUNT",
                    "value": 136.0
                }
            ],
            "groupColumns": [
                {
                    "columnName": "FLOWID",
                    "value": "FcWg77Avx41c6XIk6UU"
                },
                {
                    "columnName": "FLOWNAME",
                    "value": "补签功能"
                },
                {
                    "columnName": "STARTNODENAME",
                    "value": "人事"
                },
                {
                    "columnName": "ENDNODENAME",
                    "value": "宣传"
                },
                {
                    "columnName": "AUDITOR",
                    "value": "6itX5G75sJiN3JdAIu9"
                },
                {
                    "columnName": "DOCID",
                    "value": "Nwoj9ERh40249UZh4ZY"
                }
            ]
        },
        {
            "id": null,
            "resultFields": [
                {
                    "fieldName": "AMOUNT",
                    "value": 48.0
                }
            ],
            "groupColumns": [
                {
                    "columnName": "FLOWID",
                    "value": "TCzZJInlgVxXmQ8kv5C"
                },
                {
                    "columnName": "FLOWNAME",
                    "value": "发文流程_聚合"
                },
                {
                    "columnName": "STARTNODENAME",
                    "value": "发文草稿"
                },
                {
                    "columnName": "ENDNODENAME",
                    "value": "办公室"
                },
                {
                    "columnName": "AUDITOR",
                    "value": "SiJ037fKniXlDb808T0"
                },
                {
                    "columnName": "DOCID",
                    "value": "x1vYNzkg1LowzEmxVMR"
                }
            ]
        },
        {
            "id": null,
            "resultFields": [
                {
                    "fieldName": "AMOUNT",
                    "value": 20.0
                }
            ],
            "groupColumns": [
                {
                    "columnName": "FLOWID",
                    "value": "VN97M5KJ3TAx7sOs4KL"
                },
                {
                    "columnName": "FLOWNAME",
                    "value": "挂起"
                },
                {
                    "columnName": "STARTNODENAME",
                    "value": "宣传1"
                },
                {
                    "columnName": "ENDNODENAME",
                    "value": "测试1"
                },
                {
                    "columnName": "AUDITOR",
                    "value": "RusnXYokDS3ox4l1WDD"
                },
                {
                    "columnName": "DOCID",
                    "value": "d5mMAEssCMUQasq0Ul7"
                }
            ]
        },
        {
            "id": null,
            "resultFields": [
                {
                    "fieldName": "AMOUNT",
                    "value": 19.0
                }
            ],
            "groupColumns": [
                {
                    "columnName": "FLOWID",
                    "value": "5EWSM5Bm0UOk3cYj4T0"
                },
                {
                    "columnName": "FLOWNAME",
                    "value": "请假申请_串行"
                },
                {
                    "columnName": "STARTNODENAME",
                    "value": "申请人"
                },
                {
                    "columnName": "ENDNODENAME",
                    "value": "主管"
                },
                {
                    "columnName": "AUDITOR",
                    "value": "t5WlGHNIgD9sXH6iNQs"
                },
                {
                    "columnName": "DOCID",
                    "value": "xNNJcdyLRJkx9agI7oF"
                }
            ]
        },
        {
            "id": null,
            "resultFields": [
                {
                    "fieldName": "AMOUNT",
                    "value": 19.0
                }
            ],
            "groupColumns": [
                {
                    "columnName": "FLOWID",
                    "value": "5EWSM5Bm0UOk3cYj4T0"
                },
                {
                    "columnName": "FLOWNAME",
                    "value": "请假申请_串行"
                },
                {
                    "columnName": "STARTNODENAME",
                    "value": "申请人"
                },
                {
                    "columnName": "ENDNODENAME",
                    "value": "主管"
                },
                {
                    "columnName": "AUDITOR",
                    "value": "D2Fn7vAlmFZlvMplyQv"
                },
                {
                    "columnName": "DOCID",
                    "value": "R2oY3ekjTkSKWfKDq9W"
                }
            ]
        },
        {
            "id": null,
            "resultFields": [
                {
                    "fieldName": "AMOUNT",
                    "value": 18.0
                }
            ],
            "groupColumns": [
                {
                    "columnName": "FLOWID",
                    "value": "5EWSM5Bm0UOk3cYj4T0"
                },
                {
                    "columnName": "FLOWNAME",
                    "value": "请假申请_串行"
                },
                {
                    "columnName": "STARTNODENAME",
                    "value": "申请人"
                },
                {
                    "columnName": "ENDNODENAME",
                    "value": "主管"
                },
                {
                    "columnName": "AUDITOR",
                    "value": "TyigJ70RRrysfm2FcmP"
                },
                {
                    "columnName": "DOCID",
                    "value": "1B0bE5joroLEsTys0YM"
                }
            ]
        }
    ]
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 删除结果                 |



### 13.7查看流程实例信息

**请求方式：**GET
**请求地址：**/api/authtime/domain/applicationid/{applicationid}/workflow/flowstatert?id={id}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationid | 是       | 软件id   |
| id | 是       | 流程实例id   |

**请求包体**：



**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": {
		"id": "__00YztOVSwzIEAD0IC8F",
		"summary": "",
		"flowName": "请假单_自由流程",
		"stateLabel": "ming",
		"initiator": "ming",
		"initiatorId": "i12Qfgx0meC2eiohLsS",
		"initiatorDept": "测试1队",
		"initiatorDeptId": "__W7YnMl7TK2nwe35dipO",
		"lastAuditor": "ming",
		"firstProcessTime": 1575525023000,
		"lastProcessTime": 1575525023000,
		"flowstatertId": "__00YztOVSwzIEAD0IC8F-__eamCJJwAehv4OeZl3ZZ",
		"flowId": null,
		"formId": "OGMmff1QTZYqFk5vfeD",
		"docId": "__00YztOVSwzIEAD0IC8F",
		"status": "pending",
		"auditorNames": "ming",
		"auditorList": "[{\"instanceId\":\"__00YztOVSwzIEAD0IC8F-__eamCJJwAehv4OeZl3ZZ\",\"flowName\":\"请假单_自由流程\",\"nodes\":[{\"nodeId\":\"i12Qfgx0meC2eiohLsS\",\"stateLabel\":\"ming\",\"state\":0,\"auditors\":[{\"id\":\"i12Qfgx0meC2eiohLsS\",\"name\":\"ming\",\"userCode\":\"ming\"}],\"coAuditors\":[]}]}]",
		"coAuditorList": null,
		"lastFlowOperation": "1",
		"flowIndex": ""
	}
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 删除结果                 |

### 13.8获取可干预的节点

**请求方式：**GET
**请求地址：**/api/authtime/domain/applicationid/{applicationid}/workflow/intervention/othernodes?id={id}

**参数说明：**

| **参数**      | **必须** | **说明**   |
| ------------- | -------- | ---------- |
| applicationid | 是       | 软件id     |
| id            | 是       | 流程实例id |

**请求包体**：



**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": [{
		"id": "1532945544660",
		"type": "节点类型",
		"statelabel": "申请人"
	}, {
		"id": "1532945622003",
		"type": "节点类型",
		"statelabel": "完成"
	}]
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 删除结果                 |

### 13.9获取文档节点历史审批人

**请求方式：**GET
**请求地址：**/api/authtime/domain/applicationid/{applicationid}/workflow/intervention/approvers?id={id}&nodeid={nodeid}

**参数说明：**

| **参数**      | **必须** | **说明** |
| ------------- | -------- | -------- |
| applicationid | 是       | 软件id   |
| id            | 是       | 文档id   |
| nodeid        | 是       | 节点id   |

**请求包体**：



**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": [{
		"id": "1532945544660",
		"statelabel": "申请人"
	}, {
		"id": "1532945622003",
		"statelabel": "完成"
	}]
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 删除结果                 |

### 13.10获取流程指定审批人用户选择框列表

------

**请求方式：** GET  
**请求地址：**/api/authtime/domain/documents/{docId}/workflows/{flowId}/selectApprovers

**参数说明：**

| **参数**      | **必须** | **说明**                      |
| ------------- | -------- | ----------------------------- |
| applicationId | 是       | 软件id                        |
| docId         | 是       | 文档id                        |
| flowId        | 是       | 流程id                        |
| nodeId        | 是       | 节点id                        |
| type          | 是       | 类型（3:查询;2:角色;1:部门;） |
| selectId      | 否       | 点击角色或者部门时选中id      |
| pageNum       | 否       | 当前页                        |
| pageSize      | 否       | 每页显示数据数                |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "datas": [
            {
            "id": "11e4-63ff-5d9df2ad-9f19-57d7b83ae7be",
            "name": "admin",
            "type": 1,
            "mobile": "",
            "mobile2": null,
            "email": "",
            "avatar": "",
            "dept": "产品部",
            "deptId": "11e8-46a9-a3c6c4f2-94a7-9b60038597d7",
            "loginNo": "admin1",
            "domainId": "11e1-81e2-37f74759-9124-47aada6b7467",
            "pcmEnable": true,
            "domainAdmin": false
        }
        ],
        "pageCount": 1,
        "rowCount": 2,
        "pageNum": 1,
        "linesPerPage": 5
    }
}

```

**参数说明：**

| **参数** | **说明**               |
| -------- | ---------------------- |
| errcode  | 返回码                 |
| errmsg   | 对返回码的文本描述内容 |
| data     | 审批人用户列表         |

### 13.11干预流程

**请求方式：**POST
**请求地址：**/api/authtime/domain/applicationid/{applicationid}/workflow/intervention/flowstatert/doflow?id={id}&nextnodeids={nextnodeids} 

**参数说明：**

| **参数**      | **必须** | **说明**                      |
| ------------- | -------- | ----------------------------- |
| applicationid | 是       | 软件id                        |
| id            | 是       | 流程实例id                    |
| nextnodeids   | 是       | 干预节点id(id1,id2,id3......) |

**请求包体**：

```
{"submitTo":[{"nodeid":"1589963184813","isToPerson":true,"userids":"__5Hk3YqTU5A4zdRJ5Wbu;4czjvLGmSk1XsL50p8A"},{"nodeid":"1589963187699","isToPerson":true,"userids":"AzKGycMtONnUirI04M0"}]｝
```

**权限说明：****

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok",
	"data": [{
		"id": "1532945544660",
		"statelabel": "申请人"
	}, {
		"id": "1532945622003",
		"statelabel": "完成"
	}]
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 删除结果                 |

### 13.12批量更新当前流程节点审批人

**请求方式：**POST
**请求地址：**/api/authtime/domain/workflow/approvers/batch

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
|          |          |          |

**请求包体**：

```
{
    "userIds": [
        "__QZLADYKIXgCMomV6IK0"
    ],
    "docs": [
        {
            "docId": "__8QyeO4uMDBUTotEHhaJ",
            "applicationId": "sOZu9kthmxyP8qQfq0e"
        }
    ]
}
```

**参数说明：**

| **参数**              | **必须** | **说明**   |
| --------------------- | -------- | ---------- |
| userIds               | 是       | 用户id集合 |
| docs[0].docId         | 是       | 文档id     |
| docs[0].applicationId | 是       | 软件id     |

**权限说明：**

无。

**返回结果：**

```
{
	"errcode": 0,
	"errmsg": "ok"
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |

## 14.  **邮件配置**

### 14.1获取企业域邮件配置

**请求方式：** GET  
**请求地址：** /api/authtime/domain/{domainid}/email

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domainid | 是   |     企业域id     |

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": {
        "fetchServer": "",
        "sendHost": "191.91.919.1",
        "smtpServerPort": "",
        "domainId": "3CffNlgt9B9StIjIUPB",
        "ccAddress": "234@1.com",
        "sendAddress": "123@1.com",
        "trash": null,
        "isUseClient": "true",
        "fetchssl": "true",
        "smtpssl": "true",
        "smtpServer": null,
        "removed": "",
        "sender": "",
        "smtpAuthenticated": "",
        "fetchProtocol": "",
        "sendPassword": "123456",
        "draft": "",
        "sendAccount": "admin",
        "functionDomain": "",
        "fetchServerPort": ""
    }
}

```

**参数说明：**

| **参数**                  | **说明**                 |
| ------------------------- | ------------------------ |
| errcode                   | 返回码（0=成功，1=失败） |
| errmsg                    | 对返回码的文本描述内容   |
| data                      | 企业域邮件配置集合       |
| data[0].fetchServer       | 收取邮件服务器           |
| data[0].sendHost          | 邮件发送主机             |
| data[0].smtpServerPort    | 发送邮件服务器端口       |
| data[0].domainId          | 企业域id                 |
| data[0].ccAddress         | 邮件抄送地址             |
| data[0].sendAddress       | 邮件发送地址             |
| data[0].trash             | 邮件垃圾箱               |
| data[0].isUseClient       | 邮件客户端               |
| data[0].fetchssl          | 是否需要证书             |
| data[0].smtpssl           | 是否需要证书             |
| data[0].smtpServer        | 发送邮件服务器           |
| data[0].removed           | 已删除                   |
| data[0].sender            | 邮件发送箱               |
| data[0].smtpAuthenticated | 是否可带附件             |
| data[0].fetchProtocol     | 收取邮件协议             |
| data[0].sendPassword      | 邮件发送密码             |
| data[0].draft             | 草稿箱                   |
| data[0].sendAccount       | 邮件发送账号             |
| data[0].functionDomain    | 邮件功能域               |
| data[0].fetchServerPort   | 收取邮件端口             |
|                           |                          |

### 14.2更新企业域邮件配置

**请求方式：** PUT
**请求地址：** /api/authtime/domain/{domainid}/email

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| domnid | 是   |     企业域id     |

**请求包体**：

```
{

    "sendHost": "邮件发送主机",

    "sendAddress": "邮件发送地址",

    "sendAccount": "邮件发送账号",

    "sendPassword": "邮件发送密码",

    "ccAddress": "邮件抄送地址",

    "isUseClient": "邮件客户端",

    "functionDomain": "邮件功能域",

    "sender": "邮件发送箱",

    "draft": "草稿箱",

    "removed": "已删除",

    "fetchServer": "收取邮件服务器",

    "fetchServerPort":"收取邮件端口" ,

    "fetchProtocol": "收取邮件协议",

    "fetchssl": "是否需要证书" ,

    "smtpServerPort": "发送邮件服务器端口",

    "smtpAuthenticated": "是否可带附件",

    "smtpssl": "是否需要证书"

}
```

**权限说明：**

无。

**返回结果：**

```
{
    "errcode": 0,
    "errmsg": "ok",
    "data": "保存成功"
}

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 保存结果                 |            |







## 15.  **文件上传**

### 15.1上传文件

**请求方式：** GET  
**请求地址：** /api/authtime/uploads

**参数说明：**

| **参数** | **必须** | **说明**       |
| -------- | -------- | -------------- |
| files    | 是       | 上传文件二进制 |

**权限说明：**

无。

**返回结果：**

```
{
	"data": [{
		"fileName": "import_user_sample.xlsx",
		"filePath": "\\uploads\\2019\\8fd094db-b2d8-4114-ae00-ef94f004c38d.xlsx"
	}],
	"errcode": 0,
	"errmsg": "ok"
}
```

**参数说明：**

| **参数** | **说明**                 |      |
| -------- | ------------------------ | ---- |
| errcode  | 返回码（0=成功，1=失败） |      |
| errmsg   | 对返回码的文本描述内容   |      |


## 16.  *平台模式流程测试模块***

### 16.1获取所有流程信息

**请求方式：** GET
**请求地址：** /api/authtime/domain/applications/{applicationId}/platform/flows?pageSize={pageSize}&pageNum={pageNum}

**参数说明：**

| **参数**    | **必须** | **说明**     |
| ----------- | -------- | ------------ |
| appcationId | 是       | 软件id       |
| pageSize    | 否       | 页长度       |
| pageNum     | 否       | 当前页码**** |

```

```

**参数说明：**

**返回结果：**

```
{"errcode":0,"errmsg":"ok","data":{"linesPerPage":10,"pageCount":1,"datas":[{"subject":"山东泰华","name":"山东泰华","id":"__3a72QPe9RbHyFKEUrTT"},{"subject":"子流程","name":"子流程","id":"__5E4FAfPReq0roKZsa1S"},{"subject":"测试","name":"测试","id":"__8bj1HcIt5CawwFlZvh5"}],"rowCount":3,"pageNum":1}}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 资源对象                 |

### 16.2获取所有绑定用户

**请求方式：** GET
**请求地址：** /api/authtime/domain/applications/{applicationId}/platform/allusers

**参数说明：**

| **参数**    | **必须** | **说明** |
| ----------- | -------- | -------- |
| appcationId | 是       | 软件id   |

```

```

**参数说明：**

**返回结果：**

```
{"errcode":0,"errmsg":"ok","data":["B0","admin1","junye","janceshi","janxuanchuan"]}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 资源对象                 |

### 16.3流程实例信息列表

**请求方式：** GET
**请求地址：** /api/authtime/domain/applications/{applicationId}/platform/instance?pageSize={pageSize}&pageNum={pageNum}

**参数说明：**

| **参数**    | **必须** | **说明**     |
| ----------- | -------- | ------------ |
| appcationId | 是       | 软件id       |
| pageSize    | 否       | 页长度       |
| pageNum     | 否       | 当前页码**** |

```

```

**参数说明：**

**返回结果：**

```
{"errcode":0,"errmsg":"ok","data":{"linesPerPage":2,"pageCount":19,"datas":[{"instanceid":"123456789001-__uAQK1uDBX0OkwMX4JzW","docId":"123456789001","summary":"可研报告流程测试","userArray":["junye","admin1"],"lastAuditor":"管理员"},{"instanceid":"123456789002-__rVFDPC91zT3kL11lqAr","docId":"123456789002","userArray":["junye","junye","admin1"],"lastAuditor":"system"}],"rowCount":38,"pageNum":"1"}}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 资源对象                 |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 资源对象                 |

## 17.  定时任务

### 17.1获取绑定软件的定时任务

**请求方式：** POST
**请求地址：** /api/authtime/domain/tasks?searchword={searchword}&linesPerPage={linesPerPage}&pageNo={pageNo}

**参数说明：**

| **参数**     | **必须** | **说明**     |
| ------------ | -------- | ------------ |
| searchword   | 否       | 关键字       |
| linesPerPage | 否       | 页长度       |
| pageNo       | 否       | 当前页码**** |

```
[id1,id2]
```

**参数说明：**

**返回结果：**

```
{"errcode":0,"errmsg":"ok","data":{"rowCount":1,"linesPerPage":10,"pageNo":1,"datas":[{"id":"__oopBLDNdK2Dp1p2Csfb","uri":"/4.0功能示例.application/测试01.task/测试01.task","name":"测试01","type":1,"description":"","runningTime":1607697833000,"period":34,"runtimes":0,"terminateScript":"","taskScript":"\n//输出文本到控制台，可以在应用服务器的后台和前台调试模式下的控制查看打印内容\n(function(){\nprintln(\"当前审批人：\");\n})()","modifyTime":1607696192094,"creator":"Admin","creatorid":"Ai6hllhNjS2ull9TKGb","totalRuntimes":21,"state":0,"startupType":0,"daysOfWeek":[],"dayOfMonth":1,"repeatTimes":0,"frequency":0,"executedCount":0,"rDate":"","rTime":"","modifyTiemStr":"2020-12-11","rdate":"","rtime":""}],"pageCount":1}}
```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 资源对象                 |

### 17.2启动定时任务

**请求方式：** PUT
**请求地址：** /api/authtime/domain/task/start?id={id}&rTime={rTime}&rDate={rDate}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| id       | 是       | 任务id   |
| rTime    | 是       | 运行时间 |
| rDate    | 是       | 运行日期 |

```

```

**参数说明：**

**返回结果：**

```

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 资源对象                 |

### 17.3停止定时任务

**请求方式：** PUT
**请求地址：**  /api/authtime/domain/task/stop?id={id}

**参数说明：**

| **参数** | **必须** | **说明** |
| -------- | -------- | -------- |
| id       | 是       | 任务id   |

```

```

**参数说明：**

**返回结果：**

```

```

**参数说明：**

| **参数** | **说明**                 |
| -------- | ------------------------ |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 资源对象                 |
| errcode  | 返回码（0=成功，1=失败） |
| errmsg   | 对返回码的文本描述内容   |
| data     | 资源对象                 |
